/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.PGPDataFormatUtil;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.io.Streams;

public class PGPDataFormat
implements DataFormat {
    private String keyUserid;
    private String password;
    private String keyFileName;
    private boolean armored;
    private boolean integrity = true;

    public PGPDataFormat() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        PGPPublicKey key = PGPDataFormatUtil.findPublicKey(exchange.getContext(), this.keyFileName, this.keyUserid);
        if (key == null) {
            throw new IllegalArgumentException("Public key is null, cannot proceed");
        }
        InputStream plaintextStream = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)graph);
        byte[] compressedData = PGPDataFormatUtil.compress(IOUtils.toByteArray((InputStream)plaintextStream), "_CONSOLE", 1);
        if (this.armored) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(3, this.integrity, new SecureRandom(), "BC");
        encGen.addMethod(key);
        OutputStream encOut = encGen.open(outputStream, (long)compressedData.length);
        try {
            encOut.write(compressedData);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{encOut, outputStream});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{encOut, outputStream});
    }

    public Object unmarshal(Exchange exchange, InputStream encryptedStream) throws Exception {
        if (encryptedStream == null) {
            return null;
        }
        PGPPrivateKey key = PGPDataFormatUtil.findPrivateKey(exchange.getContext(), this.keyFileName, this.keyUserid, this.password);
        if (key == null) {
            throw new IllegalArgumentException("Private key is null, cannot proceed");
        }
        InputStream in = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)encryptedStream));
        PGPObjectFactory pgpF = new PGPObjectFactory(in = PGPUtil.getDecoderStream((InputStream)in));
        Object o = pgpF.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        PGPPublicKeyEncryptedData pbe = (PGPPublicKeyEncryptedData)enc.get(0);
        InputStream clear = pbe.getDataStream(key, "BC");
        PGPObjectFactory pgpFact = new PGPObjectFactory(clear);
        PGPCompressedData cData = (PGPCompressedData)pgpFact.nextObject();
        pgpFact = new PGPObjectFactory(cData.getDataStream());
        PGPLiteralData ld = (PGPLiteralData)pgpFact.nextObject();
        return Streams.readAll((InputStream)ld.getInputStream());
    }

    public void setArmored(boolean armored) {
        this.armored = armored;
    }

    public boolean getArmored() {
        return this.armored;
    }

    public void setIntegrity(boolean integrity) {
        this.integrity = integrity;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public void setKeyUserid(String keyUserid) {
        this.keyUserid = keyUserid;
    }

    public String getKeyUserid() {
        return this.keyUserid;
    }

    public void setKeyFileName(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }
}

