/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.camel.util.IOHelper;
import org.apache.commons.csv.CSVParser;

public class CsvIterator
implements Iterator<List<String>>,
Closeable {
    private final CSVParser parser;
    private final Reader reader;
    private String[] line;

    public CsvIterator(CSVParser parser, Reader reader) throws IOException {
        this.parser = parser;
        this.reader = reader;
        this.line = parser.getLine();
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public List<String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<String> result = Arrays.asList(this.line);
        try {
            this.line = this.parser.getLine();
        }
        catch (IOException e) {
            this.line = null;
            this.close();
            throw new IllegalStateException(e);
        }
        if (this.line == null) {
            this.close();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        IOHelper.close((Closeable)this.reader);
    }
}

