/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.csv.CsvMarshaller;
import org.apache.camel.dataformat.csv.CsvRecordConverter;
import org.apache.camel.dataformat.csv.CsvUnmarshaller;
import org.apache.camel.spi.DataFormat;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;

public class CsvDataFormat
implements DataFormat {
    private CSVFormat format = CSVFormat.DEFAULT;
    private boolean commentMarkerDisabled;
    private Character commentMarker;
    private Character delimiter;
    private boolean escapeDisabled;
    private Character escape;
    private boolean headerDisabled;
    private String[] header;
    private Boolean allowMissingColumnNames;
    private Boolean ignoreEmptyLines;
    private Boolean ignoreSurroundingSpaces;
    private boolean nullStringDisabled;
    private String nullString;
    private boolean quoteDisabled;
    private Character quote;
    private QuoteMode quoteMode;
    private boolean recordSeparatorDisabled;
    private String recordSeparator;
    private Boolean skipHeaderRecord;
    private boolean lazyLoad;
    private boolean useMaps;
    private CsvRecordConverter<?> recordConverter;
    private volatile CsvMarshaller marshaller;
    private volatile CsvUnmarshaller unmarshaller;

    public CsvDataFormat() {
    }

    public CsvDataFormat(CSVFormat format) {
        this.setFormat(format);
    }

    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws Exception {
        if (this.marshaller == null) {
            this.marshaller = CsvMarshaller.create(this.getActiveFormat(), this);
        }
        this.marshaller.marshal(exchange, object, outputStream);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        if (this.unmarshaller == null) {
            this.unmarshaller = CsvUnmarshaller.create(this.getActiveFormat(), this);
        }
        return this.unmarshaller.unmarshal(exchange, inputStream);
    }

    CSVFormat getActiveFormat() {
        CSVFormat answer = this.format;
        if (this.commentMarkerDisabled) {
            answer = answer.withCommentMarker(null);
        } else if (this.commentMarker != null) {
            answer = answer.withCommentMarker(this.commentMarker);
        }
        if (this.delimiter != null) {
            answer = answer.withDelimiter(this.delimiter.charValue());
        }
        if (this.escapeDisabled) {
            answer = answer.withEscape(null);
        } else if (this.escape != null) {
            answer = answer.withEscape(this.escape);
        }
        if (this.headerDisabled) {
            answer = answer.withHeader((String[])null);
        } else if (this.header != null) {
            answer = answer.withHeader(this.header);
        }
        if (this.allowMissingColumnNames != null) {
            answer = answer.withAllowMissingColumnNames(this.allowMissingColumnNames.booleanValue());
        }
        if (this.ignoreEmptyLines != null) {
            answer = answer.withIgnoreEmptyLines(this.ignoreEmptyLines.booleanValue());
        }
        if (this.ignoreSurroundingSpaces != null) {
            answer = answer.withIgnoreSurroundingSpaces(this.ignoreSurroundingSpaces.booleanValue());
        }
        if (this.nullStringDisabled) {
            answer = answer.withNullString(null);
        } else if (this.nullString != null) {
            answer = answer.withNullString(this.nullString);
        }
        if (this.quoteDisabled) {
            answer = answer.withQuote(null);
        } else if (this.quote != null) {
            answer = answer.withQuote(this.quote);
        }
        if (this.quoteMode != null) {
            answer = answer.withQuoteMode(this.quoteMode);
        }
        if (this.recordSeparatorDisabled) {
            answer = answer.withRecordSeparator(null);
        } else if (this.recordSeparator != null) {
            answer = answer.withRecordSeparator(this.recordSeparator);
        }
        if (this.skipHeaderRecord != null) {
            answer = answer.withSkipHeaderRecord(this.skipHeaderRecord.booleanValue());
        }
        return answer;
    }

    private void reset() {
        this.marshaller = null;
        this.unmarshaller = null;
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public CsvDataFormat setFormat(CSVFormat format) {
        this.format = format == null ? CSVFormat.DEFAULT : format;
        this.reset();
        return this;
    }

    public CsvDataFormat setFormatName(String name) {
        if (name == null) {
            this.setFormat(null);
        } else if ("DEFAULT".equals(name)) {
            this.setFormat(CSVFormat.DEFAULT);
        } else if ("RFC4180".equals(name)) {
            this.setFormat(CSVFormat.RFC4180);
        } else if ("EXCEL".equals(name)) {
            this.setFormat(CSVFormat.EXCEL);
        } else if ("TDF".equals(name)) {
            this.setFormat(CSVFormat.TDF);
        } else if ("MYSQL".equals(name)) {
            this.setFormat(CSVFormat.MYSQL);
        } else {
            throw new IllegalArgumentException("Unsupported format");
        }
        return this;
    }

    public boolean isCommentMarkerDisabled() {
        return this.commentMarkerDisabled;
    }

    public CsvDataFormat setCommentMarkerDisabled(boolean commentMarkerDisabled) {
        this.commentMarkerDisabled = commentMarkerDisabled;
        this.reset();
        return this;
    }

    public Character getCommentMarker() {
        return this.commentMarker;
    }

    public CsvDataFormat setCommentMarker(Character commentMarker) {
        this.commentMarker = commentMarker;
        this.reset();
        return this;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public CsvDataFormat setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
        this.reset();
        return this;
    }

    public boolean isEscapeDisabled() {
        return this.escapeDisabled;
    }

    public CsvDataFormat setEscapeDisabled(boolean escapeDisabled) {
        this.escapeDisabled = escapeDisabled;
        this.reset();
        return this;
    }

    public Character getEscape() {
        return this.escape;
    }

    public CsvDataFormat setEscape(Character escape) {
        this.escape = escape;
        this.reset();
        return this;
    }

    public boolean isHeaderDisabled() {
        return this.headerDisabled;
    }

    public CsvDataFormat setHeaderDisabled(boolean headerDisabled) {
        this.headerDisabled = headerDisabled;
        this.reset();
        return this;
    }

    public String[] getHeader() {
        return this.header;
    }

    public CsvDataFormat setHeader(String[] header) {
        this.header = Arrays.copyOf(header, header.length);
        this.reset();
        return this;
    }

    public Boolean getAllowMissingColumnNames() {
        return this.allowMissingColumnNames;
    }

    public CsvDataFormat setAllowMissingColumnNames(Boolean allowMissingColumnNames) {
        this.allowMissingColumnNames = allowMissingColumnNames;
        this.reset();
        return this;
    }

    public Boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public CsvDataFormat setIgnoreEmptyLines(Boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.reset();
        return this;
    }

    public Boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public CsvDataFormat setIgnoreSurroundingSpaces(Boolean ignoreSurroundingSpaces) {
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.reset();
        return this;
    }

    public boolean isNullStringDisabled() {
        return this.nullStringDisabled;
    }

    public CsvDataFormat setNullStringDisabled(boolean nullStringDisabled) {
        this.nullStringDisabled = nullStringDisabled;
        this.reset();
        return this;
    }

    public String getNullString() {
        return this.nullString;
    }

    public CsvDataFormat setNullString(String nullString) {
        this.nullString = nullString;
        this.reset();
        return this;
    }

    public boolean isQuoteDisabled() {
        return this.quoteDisabled;
    }

    public CsvDataFormat setQuoteDisabled(boolean quoteDisabled) {
        this.quoteDisabled = quoteDisabled;
        this.reset();
        return this;
    }

    public Character getQuote() {
        return this.quote;
    }

    public CsvDataFormat setQuote(Character quote) {
        this.quote = quote;
        this.reset();
        return this;
    }

    public QuoteMode getQuoteMode() {
        return this.quoteMode;
    }

    public CsvDataFormat setQuoteMode(QuoteMode quoteMode) {
        this.quoteMode = quoteMode;
        this.reset();
        return this;
    }

    public boolean isRecordSeparatorDisabled() {
        return this.recordSeparatorDisabled;
    }

    public CsvDataFormat setRecordSeparatorDisabled(boolean recordSeparatorDisabled) {
        this.recordSeparatorDisabled = recordSeparatorDisabled;
        this.reset();
        return this;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public CsvDataFormat setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
        this.reset();
        return this;
    }

    public Boolean getSkipHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public CsvDataFormat setSkipHeaderRecord(Boolean skipHeaderRecord) {
        this.skipHeaderRecord = skipHeaderRecord;
        this.reset();
        return this;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public CsvDataFormat setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
        return this;
    }

    public boolean isUseMaps() {
        return this.useMaps;
    }

    public CsvDataFormat setUseMaps(boolean useMaps) {
        this.useMaps = useMaps;
        return this;
    }

    public CsvRecordConverter<?> getRecordConverter() {
        return this.recordConverter;
    }

    public CsvDataFormat setRecordConverter(CsvRecordConverter<?> recordConverter) {
        this.recordConverter = recordConverter;
        return this;
    }
}

