/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.component.cxf.MessageInvoker;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelInvoker
implements Invoker,
MessageInvoker {
    private static final Logger LOG = Logger.getLogger(CamelInvoker.class.getName());
    private CxfConsumer cxfConsumer;

    public CamelInvoker(CxfConsumer consumer) {
        this.cxfConsumer = consumer;
    }

    @Override
    public void invoke(org.apache.cxf.message.Exchange exchange) {
        Message inMessage = exchange.getInMessage();
        CxfEndpoint endpoint = this.cxfConsumer.getEndpoint();
        CxfExchange cxfExchange = endpoint.createExchange(inMessage);
        try {
            this.cxfConsumer.getProcessor().process((Exchange)cxfExchange);
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
        this.copybackExchange(cxfExchange, exchange);
        Message outMessage = exchange.getOutMessage();
        outMessage.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (boi != null) {
            exchange.put(BindingMessageInfo.class, (Object)boi.getOutput());
        }
    }

    public void copybackExchange(CxfExchange result, org.apache.cxf.message.Exchange exchange) {
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        Message outMessage = null;
        if (result.isFailed()) {
            CxfMessage fault = result.getFault();
            outMessage = exchange.getInFaultMessage();
            if (outMessage == null) {
                outMessage = endpoint.getBinding().createMessage();
                outMessage.setExchange(exchange);
                exchange.setInFaultMessage(outMessage);
            }
            Exception ex = (Exception)fault.getBody();
            outMessage.setContent(Exception.class, (Object)ex);
        } else {
            outMessage = result.getOutMessage();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Get the response outMessage " + outMessage);
            }
            if (outMessage == null) {
                outMessage = endpoint.getBinding().createMessage();
            }
        }
        exchange.setOutMessage(outMessage);
    }

    public void updateContext(Map<String, Object> from, Map<String, Object> to) {
        if (to != null && from != null) {
            for (Map.Entry<String, Object> entry : from.entrySet()) {
                String key = entry.getKey();
                if ("org.apache.cxf.message.inbound".equals(key) || "org.apache.cxf.client".equals(key) || Message.PROTOCOL_HEADERS.equals(key)) continue;
                to.put(key, entry.getValue());
            }
        }
    }

    public Object invoke(org.apache.cxf.message.Exchange exchange, Object o) {
        CxfEndpoint endpoint = this.cxfConsumer.getEndpoint();
        List params = null;
        if (o instanceof List) {
            params = CastUtils.cast((List)((List)o));
        } else if (o != null) {
            params = new MessageContentsList(new Object[]{o});
        }
        CxfExchange cxfExchange = endpoint.createExchange(exchange.getInMessage());
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        MethodDispatcher md = (MethodDispatcher)((Service)exchange.get(Service.class)).get((Object)MethodDispatcher.class.getName());
        Method m = md.getMethod(bop);
        if (bop != null && bop.getOperationInfo().isOneWay()) {
            cxfExchange.setPattern(ExchangePattern.InOnly);
        } else {
            cxfExchange.setPattern(ExchangePattern.InOut);
        }
        cxfExchange.getIn().setHeader("operationName", m.getName());
        cxfExchange.getIn().setBody(params);
        try {
            this.cxfConsumer.getProcessor().process((Exchange)cxfExchange);
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
        Object result = null;
        if (cxfExchange.isFailed()) {
            Exception ex = (Exception)cxfExchange.getFault().getBody();
            if (ex instanceof Fault) {
                throw (Fault)ex;
            }
            throw new Fault((Throwable)ex);
        }
        result = cxfExchange.getOut().getBody();
        if (result != null) {
            if (result instanceof MessageContentsList || result instanceof List || result.getClass().isArray()) {
                return result;
            }
            MessageContentsList resList = new MessageContentsList();
            resList.add(result);
            return resList;
        }
        return result;
    }
}

