/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfMessage
extends DefaultMessage {
    private org.apache.cxf.message.Message cxfMessage;

    public CxfMessage() {
        this((org.apache.cxf.message.Message)new MessageImpl());
    }

    public CxfMessage(org.apache.cxf.message.Message cxfMessage) {
        this.cxfMessage = cxfMessage == null ? new MessageImpl() : cxfMessage;
    }

    public void copyFrom(Message that) {
        this.setMessageId(that.getMessageId());
        this.setBody(that.getBody());
        this.getHeaders().putAll(that.getHeaders());
        if (that instanceof CxfMessage) {
            CxfMessage orig = (CxfMessage)that;
            this.setMessage(orig.getMessage());
        }
    }

    public String toString() {
        if (this.cxfMessage != null) {
            return "CxfMessage: " + this.cxfMessage;
        }
        return "CxfMessage: " + this.getBody();
    }

    public CxfExchange getExchange() {
        return (CxfExchange)super.getExchange();
    }

    public org.apache.cxf.message.Message getMessage() {
        return this.cxfMessage;
    }

    public void setMessage(org.apache.cxf.message.Message cxfMessage) {
        this.cxfMessage = cxfMessage;
    }

    public Object getHeader(String name) {
        return this.cxfMessage.get((Object)name);
    }

    public void setHeader(String name, Object value) {
        this.cxfMessage.put((Object)name, value);
    }

    public Map<String, Object> getHeaders() {
        return this.cxfMessage;
    }

    public CxfMessage newInstance() {
        return new CxfMessage();
    }

    protected Object createBody() {
        return CxfBinding.extractBodyFromCxf(this.getExchange(), this.cxfMessage);
    }
}

