/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.camel.component.cxf.interceptors.AbstractMessageInInterceptor;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageInInterceptor
extends AbstractMessageInInterceptor<SoapMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapMessageInInterceptor.class);

    public SoapMessageInInterceptor() {
        super("read");
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected boolean isFaultMessage(SoapMessage message) {
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        boolean isFault = false;
        try {
            if (StaxUtils.skipToStartOfElement((XMLStreamReader)xsr)) {
                QName startQName = xsr.getName();
                isFault = message.getVersion().getFault().equals(startQName);
            }
        }
        catch (XMLStreamException xse) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", LOG, new Object[0]));
        }
        return isFault;
    }

    @Override
    protected BindingOperationInfo getBindingOperation(SoapMessage message, Document doc) {
        Exchange ex = message.getExchange();
        SoapBindingInfo soapBinding = (SoapBindingInfo)ex.get(BindingInfo.class);
        Element payloadEl = (Element)doc.getChildNodes().item(0);
        QName startQName = new QName(payloadEl.getNamespaceURI(), payloadEl.getLocalName());
        boolean client = this.isRequestor((Message)message);
        ArrayList<BindingOperationInfo> boiList = new ArrayList<BindingOperationInfo>();
        for (BindingOperationInfo boi : soapBinding.getOperations()) {
            String style = soapBinding.getStyle(boi.getOperationInfo());
            QName rootName = null;
            if ("rpc".equals(style)) {
                rootName = boi.getOperationInfo().getName();
            } else {
                List bodyParts;
                BindingMessageInfo bmi;
                BindingMessageInfo bindingMessageInfo = bmi = client ? boi.getOutput() : boi.getInput();
                if (bmi != null && (bodyParts = bmi.getMessageParts()).size() == 1) {
                    MessagePartInfo p = (MessagePartInfo)bodyParts.iterator().next();
                    rootName = p.getConcreteName();
                }
            }
            if (!startQName.equals(rootName)) continue;
            boiList.add(boi);
        }
        if (boiList.size() > 1 && LOG.isLoggable(Level.INFO)) {
            LOG.info("Mulitple matching BindingOperationIno found in Binding.");
        }
        return boiList.size() != 1 ? null : (BindingOperationInfo)boiList.get(0);
    }

    @Override
    protected List<Element> getPartList(SoapMessage inMessage, Element rootNode, BindingMessageInfo bmi) {
        ArrayList<Element> partList = new ArrayList<Element>();
        Exchange ex = inMessage.getExchange();
        SoapBindingInfo soapBinding = (SoapBindingInfo)ex.get(BindingInfo.class);
        String style = soapBinding.getStyle(bmi.getBindingOperation().getOperationInfo());
        if ("rpc".equals(style)) {
            rootNode = (Element)DOMUtils.getChild((Node)rootNode, (int)1);
        }
        partList.add(rootNode);
        return partList;
    }

    @Override
    protected Element getHeader(SoapMessage inMessage) {
        Element element = null;
        return element;
    }
}

