/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvokingContext
implements InvokingContext {
    private static final Logger LOG = Logger.getLogger(AbstractInvokingContext.class.getName());

    protected <T> T getResponseObject(Message inMessage, Map<String, Object> responseContext, Class<T> clazz) {
        Object retval = null;
        if (inMessage != null) {
            if (null != responseContext) {
                responseContext.putAll((Map<String, Object>)inMessage);
                LOG.info("set responseContext to be" + responseContext);
            }
            retval = inMessage.getContent(clazz);
        }
        return (T)retval;
    }

    protected void loggerTheMessage(Message message, String messageTile) {
        StringBuffer buffer = new StringBuffer(messageTile + "\n" + "--------------------------------------");
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                is.close();
                bos.close();
                buffer.append("\nMessage:\n");
                buffer.append(bos.getOut().toString());
                message.setContent(InputStream.class, (Object)bos.getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        buffer.append("\n--------------------------------------");
        LOG.info(buffer.toString());
    }
}

