/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.invoker;

import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.camel.component.cxf.invoker.AbstractInvokingContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawMessageInvokingContext
extends AbstractInvokingContext {
    private static final Logger LOG = Logger.getLogger(RawMessageInvokingContext.class.getName());

    @Override
    public void setRequestOutMessageContent(Message message, Map<Class, Object> contents) {
        Set<Class> entries = contents.keySet();
        for (Class obj : entries) {
            if (!(obj instanceof Class)) continue;
            message.setContent(obj, contents.get(obj));
        }
    }

    @Override
    public Object getResponseObject(Exchange exchange, Map<String, Object> responseContext) {
        return this.getResponseObject(exchange.getInMessage(), responseContext, InputStream.class);
    }

    @Override
    public void setResponseContent(Message outMessage, Object resultPayload) {
        LOG.info("Set content: " + resultPayload);
        outMessage.setContent(InputStream.class, resultPayload);
    }

    @Override
    public Map<Class, Object> getRequestContent(Message inMessage) {
        IdentityHashMap<Class, Object> contents = new IdentityHashMap<Class, Object>();
        Set set = inMessage.getContentFormats();
        for (Object obj : set) {
            if (!(obj instanceof Class)) continue;
            contents.put((Class)obj, inMessage.getContent((Class)obj));
        }
        return contents;
    }
}

