/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.ArrayList;
import javax.xml.ws.WebServiceProvider;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CamelInvoker;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfConsumer
extends DefaultConsumer<CxfExchange> {
    private CxfEndpoint endpoint;
    private Server server;

    public CxfConsumer(CxfEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        boolean isWebServiceProvider = false;
        Bus bus = BusFactory.getDefaultBus();
        ServerFactoryBean svrBean = null;
        if (endpoint.isSpringContextEndpoint()) {
            CxfEndpointBean endpointBean = endpoint.getCxfEndpointBean();
            svrBean = CxfEndpointUtils.getServerFactoryBean(endpointBean.getServiceClass());
            isWebServiceProvider = CxfEndpointUtils.hasAnnotation(endpointBean.getServiceClass(), WebServiceProvider.class);
            endpoint.configure(svrBean);
            CxfEndpointBean cxfEndpointBean = endpoint.getCxfEndpointBean();
            if (cxfEndpointBean.getServiceName() != null) {
                svrBean.setServiceName(cxfEndpointBean.getServiceName());
            }
            if (cxfEndpointBean.getEndpointName() != null) {
                svrBean.setEndpointName(cxfEndpointBean.getEndpointName());
            }
        } else {
            Class serviceClass = ClassLoaderUtils.loadClass((String)endpoint.getServiceClass(), ((Object)((Object)this)).getClass());
            svrBean = CxfEndpointUtils.getServerFactoryBean(serviceClass);
            isWebServiceProvider = CxfEndpointUtils.hasAnnotation(serviceClass, WebServiceProvider.class);
            svrBean.setAddress(endpoint.getAddress());
            svrBean.setServiceClass(serviceClass);
            if (endpoint.getServiceName() != null) {
                svrBean.setServiceName(CxfEndpointUtils.getServiceName(endpoint));
            }
            if (endpoint.getPortName() != null) {
                svrBean.setEndpointName(CxfEndpointUtils.getPortName(endpoint));
            }
            if (endpoint.getWsdlURL() != null) {
                svrBean.setWsdlURL(endpoint.getWsdlURL());
            }
        }
        DataFormat dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        svrBean.setInvoker((Invoker)new CamelInvoker(this));
        if (!dataFormat.equals((Object)DataFormat.POJO) && !isWebServiceProvider) {
            ArrayList<AbstractDataFormatFeature> features = new ArrayList<AbstractDataFormatFeature>();
            if (dataFormat.equals((Object)DataFormat.PAYLOAD)) {
                features.add(new PayLoadDataFormatFeature());
            } else if (dataFormat.equals((Object)DataFormat.MESSAGE)) {
                features.add(new MessageDataFormatFeature());
            }
            svrBean.setFeatures(features);
        }
        svrBean.setBus(bus);
        svrBean.setStart(false);
        this.server = svrBean.create();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.server.start();
    }

    protected void doStop() throws Exception {
        this.server.stop();
        super.doStop();
    }

    public CxfEndpoint getEndpoint() {
        return this.endpoint;
    }
}

