/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.logging.Logger;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.FaultOutInterceptor;
import org.apache.camel.component.cxf.interceptors.RawMessageContentRedirectInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;

public class MessageDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageDataFormatFeature.class);
    private static final String[] REMAINING_IN_PHASES = new String[]{"receive", "post-invoke"};
    private static final String[] REMAINING_OUT_PHASES = new String[]{"prepare-send", "write", "send", "prepare-send-ending"};

    public void initialize(Client client, Bus bus) {
        this.removeInterceptorWhichIsOutThePhases(client.getInInterceptors(), REMAINING_IN_PHASES);
        this.removeInterceptorWhichIsOutThePhases(client.getEndpoint().getInInterceptors(), REMAINING_IN_PHASES);
        client.getEndpoint().getBinding().getInInterceptors().clear();
        this.removeInterceptorWhichIsOutThePhases(client.getOutInterceptors(), REMAINING_OUT_PHASES);
        this.removeInterceptorWhichIsOutThePhases(client.getEndpoint().getOutInterceptors(), REMAINING_OUT_PHASES);
        client.getEndpoint().getBinding().getOutInterceptors().clear();
        client.getEndpoint().getOutInterceptors().add(new RawMessageContentRedirectInterceptor());
        client.getEndpoint().getBinding().getOutFaultInterceptors().add(new FaultOutInterceptor());
    }

    public void initialize(Server server, Bus bus) {
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getService().getInInterceptors(), REMAINING_IN_PHASES);
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getInInterceptors(), REMAINING_IN_PHASES);
        server.getEndpoint().getBinding().getInInterceptors().clear();
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getService().getOutInterceptors(), REMAINING_OUT_PHASES);
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getOutInterceptors(), REMAINING_OUT_PHASES);
        server.getEndpoint().getBinding().getOutInterceptors().clear();
        server.getEndpoint().getBinding().getOutFaultInterceptors().add(new FaultOutInterceptor());
        this.resetServiceInvokerInterceptor(server);
        server.getEndpoint().getOutInterceptors().add(new RawMessageContentRedirectInterceptor());
    }

    protected Logger getLogger() {
        return LOG;
    }
}

