/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport.spring;

import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractCamelContextBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String DEFAULT_CAMEL_CONTEXT_NAME = "camelContext";

    private String getContextId(String contextId) {
        if (ObjectHelper.isNullOrBlank((String)contextId)) {
            return DEFAULT_CAMEL_CONTEXT_NAME;
        }
        return contextId;
    }

    protected void wireCamelContext(BeanDefinitionBuilder bean, String camelContextId) {
        bean.addPropertyReference(DEFAULT_CAMEL_CONTEXT_NAME, camelContextId);
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        bean.setAbstract(true);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getLocalName();
            if (DEFAULT_CAMEL_CONTEXT_NAME.equals(name)) {
                BeanDefinition bd = ctx.getDelegate().parseCustomElement((Element)n);
                String contextId = (String)bd.getPropertyValues().getPropertyValue("id").getValue();
                this.wireCamelContext(bean, this.getContextId(contextId));
                continue;
            }
            if (!"camelContextRef".equals(name)) continue;
            String contextId = n.getTextContent();
            this.wireCamelContext(bean, this.getContextId(contextId));
        }
    }
}

