/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.cxf.common.classloader.ClassLoaderUtils;

public final class UriUtils {
    private UriUtils() {
    }

    static URL getWsdlUrl(URI uri) throws MalformedURLException {
        URL wsdlUrl = null;
        if (uri.getScheme().equals("res")) {
            if (uri.getPath() != null) {
                String path = uri.isAbsolute() ? UriUtils.getRelativePath(uri) : uri.getPath();
                wsdlUrl = ClassLoaderUtils.getResource((String)path, UriUtils.class);
            }
        } else {
            wsdlUrl = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
        }
        return wsdlUrl;
    }

    private static String getRelativePath(URI uri) {
        URI base = null;
        try {
            base = new URI("res", "", "/", "");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return base.relativize(uri).getPath();
    }
}

