/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfBinding {
    private CxfBinding() {
    }

    public static Object extractBodyFromCxf(CxfExchange exchange, org.apache.cxf.message.Message message) {
        return CxfBinding.getBody(message);
    }

    protected static Object getBody(org.apache.cxf.message.Message message) {
        Set contentFormats = message.getContentFormats();
        if (contentFormats != null) {
            for (Class contentFormat : contentFormats) {
                Object answer = message.getContent(contentFormat);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public static org.apache.cxf.message.Message createCxfMessage(CxfExchange exchange) {
        org.apache.cxf.message.Message answer = exchange.getInMessage();
        CxfMessage in = exchange.getIn();
        Object body = in.getBody(InputStream.class);
        if (body == null) {
            body = in.getBody();
        }
        if (body instanceof InputStream) {
            answer.setContent(InputStream.class, body);
        } else if (body instanceof List) {
            answer.setContent(List.class, body);
            answer.put((Object)"operationName", (Object)((String)in.getHeader("operationName")));
            answer.put((Object)"operationNameSpace", (Object)((String)in.getHeader("operationNameSpace")));
        }
        return answer;
    }

    public static void storeCxfResponse(CxfExchange exchange, org.apache.cxf.message.Message response) {
        CxfMessage out = exchange.getOut();
        if (response != null) {
            out.setMessage(response);
            DataFormat dataFormat = (DataFormat)((Object)exchange.getProperty("DATA_FORMAT"));
            if (dataFormat.equals((Object)DataFormat.MESSAGE)) {
                out.setBody(response.getContent(InputStream.class));
            }
            if (dataFormat.equals((Object)DataFormat.PAYLOAD)) {
                out.setBody(response);
            }
        }
    }

    public static void copyMessage(Message camelMessage, org.apache.cxf.message.Message cxfMessage) {
        InputStream is = (InputStream)camelMessage.getBody(InputStream.class);
        if (is != null) {
            cxfMessage.setContent(InputStream.class, (Object)is);
        } else {
            Object result = camelMessage.getBody();
            if (result != null) {
                if (result instanceof InputStream) {
                    cxfMessage.setContent(InputStream.class, result);
                } else {
                    cxfMessage.setContent(result.getClass(), result);
                }
            }
        }
    }

    public static void storeCXfResponseContext(org.apache.cxf.message.Message response, Map<String, Object> context) {
        if (context != null) {
            ContextPropertiesMapping.mapResponsefromCxf2Jaxws(context);
            response.put((Object)"ResponseContext", context);
        }
    }

    public static void storeCxfResponse(CxfExchange exchange, Object response) {
        CxfMessage out = exchange.getOut();
        if (response != null) {
            out.setBody(response);
        }
    }

    public static void storeCxfFault(CxfExchange exchange, org.apache.cxf.message.Message message) {
        CxfMessage fault = exchange.getFault();
        if (fault != null) {
            fault.setBody(CxfBinding.getBody(message));
        }
    }

    public static Map<String, Object> propogateContext(org.apache.cxf.message.Message message, Map<String, Object> context) {
        Map requestContext = CastUtils.cast((Map)((Map)message.get((Object)"RequestContext")));
        HashMap<String, Object> responseContext = CastUtils.cast((Map)((Map)message.get((Object)"ResponseContext")));
        if (requestContext != null) {
            ContextPropertiesMapping.mapRequestfromJaxws2Cxf((Map)requestContext);
        }
        if (responseContext == null) {
            responseContext = new HashMap<String, Object>();
        } else {
            responseContext.clear();
        }
        context.put("RequestContext", requestContext);
        context.put("ResponseContext", responseContext);
        return responseContext;
    }
}

