/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.message.Message;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpoint
extends DefaultEndpoint<CxfExchange> {
    private final CxfComponent component;
    private final String address;
    private String wsdlURL;
    private String serviceClass;
    private String portName;
    private String serviceName;
    private String dataFormat;
    private String beanId;
    private boolean isWrapped;
    private boolean isSpringContextEndpoint;
    private boolean inOut = true;
    private Boolean isSetDefaultBus;
    private ConfigurerImpl configurer;
    private CxfEndpointBean cxfEndpointBean;

    public CxfEndpoint(String uri, String address, CxfComponent component) {
        super(uri, (Component)component);
        this.component = component;
        this.address = address;
        if (address.startsWith("bean:")) {
            this.isSpringContextEndpoint = true;
            this.beanId = address.substring("bean:".length());
            if (this.beanId.startsWith("//")) {
                this.beanId = this.beanId.substring(2);
            }
            SpringCamelContext context = (SpringCamelContext)this.getCamelContext();
            this.configurer = new ConfigurerImpl(context.getApplicationContext());
            this.cxfEndpointBean = (CxfEndpointBean)((Object)context.getApplicationContext().getBean(this.beanId));
            assert (this.cxfEndpointBean != null);
        }
    }

    public Producer<CxfExchange> createProducer() throws Exception {
        return new CxfProducer(this);
    }

    public Consumer<CxfExchange> createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor);
    }

    public CxfExchange createExchange() {
        return new CxfExchange(this.getCamelContext(), this.getExchangePattern());
    }

    public CxfExchange createExchange(ExchangePattern pattern) {
        return new CxfExchange(this.getCamelContext(), pattern);
    }

    public CxfExchange createExchange(Message inMessage) {
        return new CxfExchange(this.getCamelContext(), this.getExchangePattern(), inMessage);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String format) {
        this.dataFormat = format;
    }

    public boolean isSpringContextEndpoint() {
        return this.isSpringContextEndpoint;
    }

    public String getAddress() {
        return this.address;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public void setSetDefaultBus(Boolean set) {
        this.isSetDefaultBus = set;
    }

    public Boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String className) {
        this.serviceClass = className;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.isWrapped = wrapped;
    }

    public CxfComponent getComponent() {
        return this.component;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public CxfEndpointBean getCxfEndpointBean() {
        return this.cxfEndpointBean;
    }

    public void configure(Object beanInstance) {
        this.configurer.configureBean(this.beanId, beanInstance);
    }

    public ApplicationContext getApplicationContext() {
        if (this.getCamelContext() instanceof SpringCamelContext) {
            SpringCamelContext context = (SpringCamelContext)this.getCamelContext();
            return context.getApplicationContext();
        }
        return null;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.component.getHeaderFilterStrategy();
    }
}

