/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.camel.CamelException;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.UriUtils;
import org.apache.camel.component.cxf.util.WSDLSoapServiceFactoryBean;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfEndpointUtils {
    public static final String PROP_NAME_PORT = "port";
    public static final String PROP_NAME_SERVICE = "service";
    public static final String PROP_NAME_SERVICECLASS = "serviceClass";
    public static final String PROP_NAME_DATAFORMAT = "dataFormat";
    public static final String DATAFORMAT_POJO = "pojo";
    public static final String DATAFORMAT_MESSAGE = "message";
    public static final String DATAFORMAT_PAYLOAD = "payload";
    private static final Logger LOG = LogUtils.getL7dLogger(CxfEndpointUtils.class);

    private CxfEndpointUtils() {
    }

    static QName getQName(String name) {
        QName qName = null;
        if (name != null) {
            try {
                qName = QName.valueOf(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return qName;
    }

    public static QName getPortName(CxfEndpoint endpoint) {
        return CxfEndpointUtils.getQName(endpoint.getPortName());
    }

    public static QName getServiceName(CxfEndpoint endpoint) {
        return CxfEndpointUtils.getQName(endpoint.getServiceName());
    }

    public static EndpointInfo getEndpointInfo(Service service, CxfEndpoint endpoint) {
        EndpointInfo endpointInfo = null;
        Collection endpoints = ((ServiceInfo)service.getServiceInfos().get(0)).getEndpoints();
        if (endpoints.size() == 1) {
            endpointInfo = (EndpointInfo)endpoints.iterator().next();
        } else {
            String port = endpoint.getPortName();
            if (port != null) {
                QName endpointName = QName.valueOf(port);
                endpointInfo = ((ServiceInfo)service.getServiceInfos().get(0)).getEndpoint(endpointName);
            }
        }
        return endpointInfo;
    }

    public static Class getSEIClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        return ClassLoaderUtils.loadClass((String)className, CxfEndpointUtils.class);
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        return CxfEndpointUtils.hasAnnotation(cls, WebService.class) || CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class);
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls == null || cls == Object.class) {
            return false;
        }
        if (null != cls.getAnnotation(annotation)) {
            return true;
        }
        for (Class<?> interfaceClass : cls.getInterfaces()) {
            if (null == interfaceClass.getAnnotation(annotation)) continue;
            return true;
        }
        return CxfEndpointUtils.hasAnnotation(cls.getSuperclass(), annotation);
    }

    public static ServerFactoryBean getServerFactoryBean(Class<?> cls) throws CamelException {
        ServerFactoryBean serverFactory = null;
        try {
            if (cls == null) {
                serverFactory = new ServerFactoryBean();
                serverFactory.setServiceFactory((ReflectionServiceFactoryBean)new WSDLSoapServiceFactoryBean());
            } else {
                boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
                serverFactory = isJSR181SEnabled ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
            }
            return serverFactory;
        }
        catch (Exception e) {
            throw new CamelException((Throwable)e);
        }
    }

    public static ClientProxyFactoryBean getClientFactoryBean(Class<?> cls) throws CamelException {
        ClientProxyFactoryBean clientFactory = null;
        try {
            if (cls == null) {
                clientFactory = new ClientProxyFactoryBean();
                clientFactory.setServiceFactory((ReflectionServiceFactoryBean)new WSDLSoapServiceFactoryBean());
            } else {
                boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
                clientFactory = isJSR181SEnabled ? new JaxWsProxyFactoryBean() : new ClientProxyFactoryBean();
            }
            return clientFactory;
        }
        catch (Exception e) {
            throw new CamelException((Throwable)e);
        }
    }

    public static void checkEndpiontIntegration(CxfEndpoint endpoint, Bus bus) throws CamelException {
        String wsdlLocation = endpoint.getWsdlURL();
        QName serviceQName = CxfEndpointUtils.getQName(endpoint.getServiceName());
        String serviceClassName = endpoint.getServiceClass();
        DataFormat dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        URL wsdlUrl = null;
        if (wsdlLocation != null) {
            try {
                wsdlUrl = UriUtils.getWsdlUrl(new URI(wsdlLocation));
            }
            catch (Exception e) {
                throw new CamelException((Throwable)e);
            }
        }
        if (serviceQName == null) {
            throw new CamelException(new Message("SVC_QNAME_NOT_FOUND_X", LOG, new Object[]{endpoint.getServiceName()}).toString());
        }
        if (serviceClassName == null && dataFormat == DataFormat.POJO) {
            throw new CamelException(new Message("SVC_CLASS_PROP_IS_REQUIRED_X", LOG, new Object[0]).toString());
        }
        WSDLServiceFactory serviceFactory = null;
        try {
            if (serviceClassName != null) {
                Class cls = ClassLoaderUtils.loadClass((String)serviceClassName, CxfEndpointUtils.class);
                boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
                serviceFactory = isJSR181SEnabled ? new JaxWsServiceFactoryBean() : new ReflectionServiceFactoryBean();
                serviceFactory.setBus(bus);
                if (wsdlUrl != null) {
                    ((ReflectionServiceFactoryBean)serviceFactory).setWsdlURL(wsdlUrl);
                }
                if (serviceQName != null) {
                    ((ReflectionServiceFactoryBean)serviceFactory).setServiceName(serviceQName);
                }
                ((ReflectionServiceFactoryBean)serviceFactory).setServiceClass(cls);
            } else {
                if (wsdlUrl == null) {
                    throw new CamelException(new Message("SVC_WSDL_URL_IS_NULL_X", LOG, new Object[]{wsdlLocation}).toString());
                }
                serviceFactory = new WSDLServiceFactory(bus, wsdlUrl, serviceQName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new CamelException(new Message("CLASS_X_NOT_FOUND ", LOG, new Object[]{serviceClassName}).toString(), (Throwable)cnfe);
        }
        catch (Exception e) {
            throw new CamelException((Throwable)e);
        }
    }

    public static boolean getSetDefaultBus(CxfEndpoint endpoint) {
        Boolean isSetDefaultBus = null;
        CxfEndpointBean cxfEndpointBean = endpoint.getCxfEndpointBean();
        if (cxfEndpointBean != null && cxfEndpointBean.getProperties() != null) {
            String value = (String)cxfEndpointBean.getProperties().get("setDefaultBus");
            isSetDefaultBus = Boolean.valueOf(value);
        }
        if (isSetDefaultBus != null && endpoint.isSetDefaultBus() == null) {
            return isSetDefaultBus;
        }
        if (endpoint.isSetDefaultBus() != null) {
            return endpoint.isSetDefaultBus();
        }
        return false;
    }

    public static void checkServiceClass(Class clazz) throws CamelException {
        if (clazz == null) {
            throw new CamelException("serviceClass is required for CXF endpoint configuration");
        }
    }

    public static void checkServiceClassName(String className) throws CamelException {
        if (ObjectHelper.isNullOrBlank((String)className)) {
            throw new CamelException("serviceClass is required for CXF endpoint configuration");
        }
    }

    public static DataFormat getDataFormat(CxfEndpoint endpoint) throws CamelException {
        CxfEndpointBean cxfEndpointBean;
        String dataFormatString = endpoint.getDataFormat();
        if (dataFormatString == null && (cxfEndpointBean = endpoint.getCxfEndpointBean()) != null && cxfEndpointBean.getProperties() != null) {
            dataFormatString = (String)cxfEndpointBean.getProperties().get(PROP_NAME_DATAFORMAT);
        }
        if (dataFormatString == null) {
            return DataFormat.POJO;
        }
        DataFormat retval = DataFormat.asEnum(dataFormatString);
        if (retval == DataFormat.UNKNOWN) {
            throw new CamelException(new Message("INVALID_MESSAGE_FORMAT_XXXX", LOG, new Object[]{dataFormatString}).toString());
        }
        return retval;
    }
}

