/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfHeaderHelper {
    private CxfHeaderHelper() {
    }

    public static void propagateCamelToCxf(HeaderFilterStrategy strategy, Map<String, Object> headers, Message message) {
        HashMap cxfHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (cxfHeaders == null) {
            cxfHeaders = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, cxfHeaders);
        }
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (strategy == null || strategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue())) continue;
            if ("content.type".equals(entry.getKey())) {
                message.put((Object)"Content-Type", entry.getValue());
                continue;
            }
            if ("RequestContext".equals(entry.getKey()) || "ResponseContext".equals(entry.getKey())) {
                message.put((Object)entry.getKey(), entry.getValue());
                continue;
            }
            ArrayList<String> listValue = new ArrayList<String>();
            listValue.add(entry.getValue().toString());
            cxfHeaders.put(entry.getKey(), listValue);
        }
    }

    public static void propagateCxfToCamel(HeaderFilterStrategy strategy, Message message, Map<String, Object> headers) {
        String key;
        Object value;
        if (strategy == null) {
            return;
        }
        Map cxfHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue())) continue;
                headers.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
            }
        }
        if ((value = message.get((Object)(key = "Content-Type"))) != null && !strategy.applyFilterToExternalHeaders(key, value)) {
            headers.put("content.type", value);
        }
        if ((value = message.get((Object)(key = "RequestContext"))) != null && !strategy.applyFilterToExternalHeaders(key, value)) {
            headers.put(key, value);
        }
        if ((value = message.get((Object)(key = "ResponseContext"))) != null && !strategy.applyFilterToExternalHeaders(key, value)) {
            headers.put(key, value);
        }
    }
}

