/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.util.AsyncProcessorHelper;

public class AsyncProcessorDecorator
implements AsyncProcessor {
    private final AsyncProcessor processor;
    private final Processor before;
    private final Processor after;

    public AsyncProcessorDecorator(Processor processor, Processor before, Processor after) {
        this.processor = AsyncProcessorTypeConverter.convert((Processor)processor);
        this.before = before;
        this.after = after;
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process((AsyncProcessor)this, (Exchange)exchange);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        try {
            this.before.process(exchange);
        }
        catch (Throwable t) {
            exchange.setException(t);
            callback.done(true);
            return true;
        }
        return this.processor.process(exchange, new AsyncCallback(){

            public void done(boolean doneSynchronously) {
                try {
                    AsyncProcessorDecorator.this.after.process(exchange);
                    callback.done(doneSynchronously);
                }
                catch (Throwable t) {
                    exchange.setException(t);
                }
            }
        });
    }
}

