/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.MessageInvoker;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelInvoker
implements Invoker,
MessageInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(CamelInvoker.class);
    private CxfConsumer cxfConsumer;
    private DataFormat dataFormat;

    public CamelInvoker(CxfConsumer consumer, DataFormat dataFormat) {
        this.cxfConsumer = consumer;
        this.dataFormat = dataFormat;
    }

    @Override
    public void invoke(org.apache.cxf.message.Exchange exchange) {
        org.apache.cxf.message.Message inMessage = exchange.getInMessage();
        CxfEndpoint endpoint = this.cxfConsumer.getEndpoint();
        CxfExchange cxfExchange = endpoint.createExchange(inMessage);
        cxfExchange.setProperty("CamelCXFDataFormat", (Object)this.dataFormat);
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        cxfExchange.setProperty(BindingOperationInfo.class.toString(), bop);
        if (bop != null && bop.getOperationInfo().isOneWay()) {
            cxfExchange.setPattern(ExchangePattern.InOnly);
        } else {
            cxfExchange.setPattern(ExchangePattern.InOut);
        }
        try {
            this.cxfConsumer.getProcessor().process((Exchange)cxfExchange);
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
        this.checkFailure(cxfExchange);
        this.copybackExchange(cxfExchange, exchange);
        org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
        outMessage.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (boi != null) {
            exchange.put(BindingMessageInfo.class, (Object)boi.getOutput());
        }
    }

    public void copybackExchange(CxfExchange result, org.apache.cxf.message.Exchange exchange) {
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = null;
        if (result.isFailed()) {
            Throwable ex;
            CxfMessage fault = result.getFault();
            outMessage = exchange.getInFaultMessage();
            if (outMessage == null) {
                outMessage = endpoint.getBinding().createMessage();
                outMessage.setExchange(exchange);
                exchange.setInFaultMessage(outMessage);
            }
            if ((ex = (Throwable)fault.getBody()) != null) {
                outMessage.setContent(Throwable.class, (Object)ex);
            } else {
                outMessage.setContent(Throwable.class, (Object)result.getException());
            }
        } else {
            outMessage = result.getOutMessage();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Get the response outMessage " + outMessage);
            }
            CxfMessage camelMessage = result.getOut();
            CxfBinding.copyMessage((Message)camelMessage, outMessage);
        }
        exchange.setOutMessage(outMessage);
    }

    private void checkFailure(CxfExchange cxfExchange) throws Fault {
        if (cxfExchange.isFailed()) {
            Throwable ex = (Throwable)cxfExchange.getFault().getBody();
            if (ex instanceof Fault) {
                throw (Fault)ex;
            }
            if (ex == null) {
                ex = cxfExchange.getException();
            }
            throw new Fault(ex);
        }
    }

    public void updateContext(Map<String, Object> from, Map<String, Object> to) {
        if (to != null && from != null) {
            for (Map.Entry<String, Object> entry : from.entrySet()) {
                String key = entry.getKey();
                if ("org.apache.cxf.message.inbound".equals(key) || "org.apache.cxf.client".equals(key) || org.apache.cxf.message.Message.PROTOCOL_HEADERS.equals(key)) continue;
                to.put(key, entry.getValue());
            }
        }
    }

    public Object invoke(org.apache.cxf.message.Exchange exchange, Object o) {
        List headers;
        Map responseContext;
        org.apache.cxf.message.Message message;
        CxfEndpoint endpoint = this.cxfConsumer.getEndpoint();
        List params = null;
        if (o instanceof List) {
            params = CastUtils.cast((List)((List)o));
        } else if (o != null) {
            params = new MessageContentsList(new Object[]{o});
        }
        CxfExchange cxfExchange = endpoint.createExchange(exchange.getInMessage());
        cxfExchange.setProperty("CamelCXFDataFormat", (Object)this.dataFormat);
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        MethodDispatcher md = (MethodDispatcher)((Service)exchange.get(Service.class)).get((Object)MethodDispatcher.class.getName());
        Method m = md.getMethod(bop);
        cxfExchange.setProperty(BindingOperationInfo.class.toString(), bop);
        if (bop != null && bop.getOperationInfo().isOneWay()) {
            cxfExchange.setPattern(ExchangePattern.InOnly);
        } else {
            cxfExchange.setPattern(ExchangePattern.InOut);
        }
        if (bop != null && bop.getName() != null) {
            cxfExchange.getIn().setHeader("operationNameSpace", bop.getName().getNamespaceURI());
            cxfExchange.getIn().setHeader("operationName", bop.getName().getLocalPart());
        } else {
            cxfExchange.getIn().setHeader("operationName", m.getName());
        }
        CxfHeaderHelper.propagateCxfToCamel(endpoint.getHeaderFilterStrategy(), exchange.getInMessage(), cxfExchange.getIn().getHeaders());
        cxfExchange.getIn().setBody(params);
        try {
            this.cxfConsumer.getProcessor().process((Exchange)cxfExchange);
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
        Object result = null;
        if (cxfExchange.isFailed()) {
            Throwable ex = (Throwable)cxfExchange.getFault().getBody();
            if (ex instanceof Fault) {
                throw (Fault)ex;
            }
            if (ex == null) {
                ex = cxfExchange.getException();
            }
            throw new Fault(ex);
        }
        org.apache.cxf.message.Message cxfMessage = exchange.getOutMessage();
        if (cxfMessage == null && !exchange.isOneWay()) {
            Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
            cxfMessage = ep.getBinding().createMessage();
            exchange.setOutMessage(cxfMessage);
        }
        if ((message = cxfExchange.getOutMessage()) != null && (responseContext = CastUtils.cast((Map)((Map)message.get((Object)"ResponseContext")))) != null && (headers = CastUtils.cast((List)((List)responseContext.get(Header.HEADER_LIST)))) != null) {
            cxfMessage.put((Object)Header.HEADER_LIST, (Object)headers);
        }
        if ((result = cxfExchange.getOut().getBody()) != null) {
            if (result instanceof MessageContentsList || result instanceof List || result.getClass().isArray()) {
                return result;
            }
            MessageContentsList resList = new MessageContentsList();
            resList.add(result);
            return resList;
        }
        return result;
    }
}

