/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.camel.component.cxf.interceptors.AbstractMessageInInterceptor;
import org.apache.cxf.bindings.xformat.XMLBindingMessageFormat;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMessageInInterceptor
extends AbstractMessageInInterceptor<XMLMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLMessageInInterceptor.class);

    public XMLMessageInInterceptor() {
        super("read");
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected boolean isFaultMessage(XMLMessage message) {
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        boolean isFault = false;
        try {
            if (StaxUtils.skipToStartOfElement((XMLStreamReader)xsr)) {
                QName startQName = xsr.getName();
                isFault = "http://cxf.apache.org/bindings/xformat".equals(startQName.getNamespaceURI()) && "XMLFault".equals(startQName.getLocalPart());
            }
        }
        catch (XMLStreamException xse) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", LOG, new Object[0]));
        }
        return isFault;
    }

    @Override
    protected BindingOperationInfo getBindingOperation(XMLMessage message, Document doc) {
        Exchange ex = message.getExchange();
        BindingInfo binding = (BindingInfo)ex.get(BindingInfo.class);
        if (binding == null) {
            Endpoint ep = (Endpoint)ex.get(Endpoint.class);
            binding = ep.getEndpointInfo().getBinding();
        }
        Element payloadEl = (Element)doc.getChildNodes().item(0);
        QName startQName = new QName(payloadEl.getNamespaceURI(), payloadEl.getLocalName());
        boolean client = this.isRequestor((Message)message);
        ArrayList<BindingOperationInfo> boiList = new ArrayList<BindingOperationInfo>();
        for (BindingOperationInfo boi : binding.getOperations()) {
            BindingMessageInfo bmi = client ? boi.getOutput() : boi.getInput();
            QName rootName = null;
            if (bmi != null) {
                XMLBindingMessageFormat msgFormat = (XMLBindingMessageFormat)bmi.getExtensor(XMLBindingMessageFormat.class);
                if (msgFormat != null) {
                    rootName = msgFormat.getRootNode();
                } else {
                    List bodyParts = bmi.getMessageParts();
                    if (bodyParts.size() == 1) {
                        MessagePartInfo p = (MessagePartInfo)bodyParts.iterator().next();
                        rootName = p.getConcreteName();
                    }
                }
            }
            if (!startQName.equals(rootName)) continue;
            boiList.add(boi);
        }
        BindingOperationInfo match = null;
        if (boiList.size() > 1) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Mulitple matching BindingOperationIno found in Binding.");
            }
        } else if (!boiList.isEmpty()) {
            match = (BindingOperationInfo)boiList.get(0);
        }
        return match;
    }

    @Override
    protected List<Element> getPartList(XMLMessage inMessage, Element rootNode, BindingMessageInfo bmi) {
        ArrayList<Element> partList = new ArrayList<Element>();
        XMLBindingMessageFormat msgFormat = (XMLBindingMessageFormat)bmi.getExtensor(XMLBindingMessageFormat.class);
        if (msgFormat != null) {
            NodeList nodeList = rootNode.getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                partList.add((Element)nodeList.item(idx));
            }
        } else {
            partList.add(rootNode);
        }
        return partList;
    }
}

