/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.headers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.cxf.headers.DefaultMessageHeadersRelay;
import org.apache.camel.component.cxf.headers.Direction;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.headers.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageHeadersRelay
extends DefaultMessageHeadersRelay {
    private static final List<String> ACTIVATION_NS = Arrays.asList("http://schemas.xmlsoap.org/soap/", "http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/");

    @Override
    public List<String> getActivationNamespaces() {
        return ACTIVATION_NS;
    }

    @Override
    public void relay(Direction direction, List<Header> from, List<Header> to) {
        Iterator<Header> it = from.iterator();
        while (it.hasNext()) {
            Header header = it.next();
            if (!(header instanceof SoapHeader)) continue;
            SoapHeader soapHeader = (SoapHeader)SoapHeader.class.cast(header);
            boolean dropped = false;
            Iterator itv = SoapVersionFactory.getInstance().getVersions();
            while (itv.hasNext()) {
                SoapVersion version = (SoapVersion)itv.next();
                if (soapHeader.getActor() == null || !soapHeader.getActor().equals(version.getNextRole())) continue;
                it.remove();
                dropped = true;
                break;
            }
            if (dropped) continue;
            to.add(header);
        }
    }
}

