/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfBinding {
    private CxfBinding() {
    }

    public static Object extractBodyFromCxf(CxfExchange exchange, org.apache.cxf.message.Message message) {
        return CxfBinding.getBody(message);
    }

    protected static Object getBody(org.apache.cxf.message.Message message) {
        Set contentFormats = message.getContentFormats();
        if (contentFormats != null) {
            for (Class contentFormat : contentFormats) {
                Object answer = message.getContent(contentFormat);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    public static org.apache.cxf.message.Message createCxfMessage(CxfExchange exchange) {
        return CxfBinding.createCxfMessage((HeaderFilterStrategy)new CxfHeaderFilterStrategy(), exchange);
    }

    public static org.apache.cxf.message.Message createCxfMessage(HeaderFilterStrategy strategy, CxfExchange exchange) {
        org.apache.cxf.message.Message answer = exchange.getInMessage();
        CxfMessage in = exchange.getIn();
        try {
            List body = in.getBody(List.class);
            answer.setContent(List.class, (Object)body);
            CxfHeaderHelper.propagateCamelToCxf(strategy, in.getHeaders(), answer);
        }
        catch (NoTypeConversionAvailableException ex) {
            try {
                InputStream body = in.getBody(InputStream.class);
                answer.setContent(InputStream.class, (Object)body);
            }
            catch (NoTypeConversionAvailableException ex2) {
                // empty catch block
            }
        }
        HashMap requestContext = CastUtils.cast((Map)((Map)answer.get((Object)"RequestContext")));
        if (requestContext == null) {
            requestContext = new HashMap();
        }
        if (exchange.getExchange() != null) {
            requestContext.putAll(exchange.getExchange());
        }
        if (exchange.getProperties() != null) {
            requestContext.putAll(exchange.getProperties());
        }
        answer.put((Object)"RequestContext", requestContext);
        return answer;
    }

    public static void storeCxfResponse(CxfExchange exchange, org.apache.cxf.message.Message response) {
        CxfBinding.storeCxfResponse((HeaderFilterStrategy)new CxfHeaderFilterStrategy(), exchange, response);
    }

    public static void storeCxfResponse(HeaderFilterStrategy strategy, CxfExchange exchange, org.apache.cxf.message.Message response) {
        CxfMessage out = exchange.getOut();
        if (response != null) {
            CxfHeaderHelper.propagateCxfToCamel(strategy, response, out.getHeaders());
            out.setMessage(response);
            DataFormat dataFormat = (DataFormat)((Object)exchange.getProperty("DATA_FORMAT"));
            if (dataFormat.equals((Object)DataFormat.MESSAGE)) {
                out.setBody(response.getContent(InputStream.class));
            }
            if (dataFormat.equals((Object)DataFormat.PAYLOAD)) {
                out.setBody(response);
            }
        }
    }

    public static void copyMessage(Message camelMessage, org.apache.cxf.message.Message cxfMessage) {
        CxfBinding.copyMessage((HeaderFilterStrategy)new CxfHeaderFilterStrategy(), camelMessage, cxfMessage);
    }

    public static void copyMessage(HeaderFilterStrategy strategy, Message camelMessage, org.apache.cxf.message.Message cxfMessage) {
        CxfHeaderHelper.propagateCamelToCxf(strategy, camelMessage.getHeaders(), cxfMessage);
        try {
            InputStream is = (InputStream)camelMessage.getBody(InputStream.class);
            if (is != null) {
                cxfMessage.setContent(InputStream.class, (Object)is);
            }
        }
        catch (NoTypeConversionAvailableException ex) {
            Object result = camelMessage.getBody();
            if (result instanceof InputStream) {
                cxfMessage.setContent(InputStream.class, result);
            }
            cxfMessage.setContent(result.getClass(), result);
        }
    }

    public static void storeCXfResponseContext(org.apache.cxf.message.Message response, Map<String, Object> context) {
        if (context != null) {
            WrappedMessageContext messageContext = new WrappedMessageContext(context, null, MessageContext.Scope.HANDLER);
            response.put((Object)"ResponseContext", (Object)messageContext);
        }
    }

    public static void storeCxfResponse(CxfExchange exchange, Object response) {
        CxfMessage out = exchange.getOut();
        if (response != null) {
            out.setBody(response);
        }
    }

    public static void storeCxfFault(CxfExchange exchange, org.apache.cxf.message.Message message) {
        CxfMessage fault = exchange.getFault();
        if (fault != null) {
            fault.setBody(CxfBinding.getBody(message));
        }
    }

    public static Map<String, Object> propogateContext(org.apache.cxf.message.Message message, Map<String, Object> context) {
        HashMap requestContext = CastUtils.cast((Map)((Map)message.get((Object)"RequestContext")));
        HashMap<String, Object> responseContext = CastUtils.cast((Map)((Map)message.get((Object)"ResponseContext")));
        if (requestContext != null) {
            HashMap realMap = new HashMap();
            WrappedMessageContext ctx = new WrappedMessageContext(realMap, null, MessageContext.Scope.APPLICATION);
            ctx.putAll((Map)requestContext);
            requestContext = realMap;
        }
        if (responseContext == null) {
            responseContext = new HashMap<String, Object>();
        } else {
            responseContext.clear();
        }
        context.put("RequestContext", requestContext);
        context.put("ResponseContext", responseContext);
        return responseContext;
    }
}

