/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import javax.xml.ws.WebServiceProvider;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CamelInvoker;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfConsumer
extends DefaultConsumer<CxfExchange> {
    private CxfEndpoint endpoint;
    private Server server;

    public CxfConsumer(CxfEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        Bus bus = null;
        this.endpoint = endpoint;
        boolean isWebServiceProvider = false;
        if (endpoint.getApplicationContext() != null) {
            bus = endpoint.getCxfEndpointBean().getBus();
            if (CxfEndpointUtils.getSetDefaultBus(endpoint)) {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
        } else {
            bus = BusFactory.getThreadDefaultBus();
        }
        ServerFactoryBean svrBean = null;
        if (endpoint.isSpringContextEndpoint()) {
            CxfEndpointBean endpointBean = endpoint.getCxfEndpointBean();
            CxfEndpointUtils.checkServiceClass(endpointBean.getServiceClass());
            svrBean = CxfEndpointUtils.getServerFactoryBean(endpointBean.getServiceClass());
            isWebServiceProvider = CxfEndpointUtils.hasAnnotation(endpointBean.getServiceClass(), WebServiceProvider.class);
            endpoint.configure(svrBean);
        } else {
            CxfEndpointUtils.checkServiceClassName(endpoint.getServiceClass());
            Class serviceClass = ClassLoaderUtils.loadClass((String)endpoint.getServiceClass(), ((Object)((Object)this)).getClass());
            svrBean = CxfEndpointUtils.getServerFactoryBean(serviceClass);
            isWebServiceProvider = CxfEndpointUtils.hasAnnotation(serviceClass, WebServiceProvider.class);
            svrBean.setAddress(endpoint.getAddress());
            svrBean.setServiceClass(serviceClass);
            if (endpoint.getWsdlURL() != null) {
                svrBean.setWsdlURL(endpoint.getWsdlURL());
            }
        }
        if (CxfEndpointUtils.getServiceName(endpoint) != null) {
            svrBean.setServiceName(CxfEndpointUtils.getServiceName(endpoint));
        }
        if (CxfEndpointUtils.getServiceName(endpoint) != null) {
            svrBean.setEndpointName(CxfEndpointUtils.getPortName(endpoint));
        }
        DataFormat dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        svrBean.setInvoker((Invoker)new CamelInvoker(this));
        if (!dataFormat.equals((Object)DataFormat.POJO) && !isWebServiceProvider) {
            if (dataFormat.equals((Object)DataFormat.PAYLOAD)) {
                svrBean.getFeatures().add(new PayLoadDataFormatFeature());
            } else if (dataFormat.equals((Object)DataFormat.MESSAGE)) {
                svrBean.getFeatures().add(new MessageDataFormatFeature());
            }
        }
        svrBean.setBus(bus);
        svrBean.setStart(false);
        this.server = svrBean.create();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.server.start();
    }

    protected void doStop() throws Exception {
        this.server.stop();
        super.doStop();
    }

    public CxfEndpoint getEndpoint() {
        return this.endpoint;
    }
}

