/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.invoker.CxfClient;
import org.apache.camel.component.cxf.invoker.CxfClientFactoryBean;
import org.apache.camel.component.cxf.invoker.InvokingContext;
import org.apache.camel.component.cxf.invoker.InvokingContextFactory;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfProducer
extends DefaultProducer<CxfExchange> {
    private CxfEndpoint endpoint;
    private Client client;
    private DataFormat dataFormat;

    public CxfProducer(CxfEndpoint endpoint) throws CamelException {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.dataFormat = CxfEndpointUtils.getDataFormat(endpoint);
        this.client = this.dataFormat.equals((Object)DataFormat.POJO) ? this.createClientFromClientFactoryBean(null) : this.createClientForStreamMessage();
    }

    private Client createClientForStreamMessage() throws CamelException {
        CxfClientFactoryBean cfb = new CxfClientFactoryBean();
        Class serviceClass = null;
        if (this.endpoint.isSpringContextEndpoint()) {
            CxfEndpointBean cxfEndpointBean = this.endpoint.getCxfEndpointBean();
            serviceClass = cxfEndpointBean.getServiceClass();
            CxfEndpointUtils.checkServiceClass(serviceClass);
        } else {
            CxfEndpointUtils.checkServiceClassName(this.endpoint.getServiceClass());
            try {
                serviceClass = ClassLoaderUtils.loadClass((String)this.endpoint.getServiceClass(), ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                throw new CamelException((Throwable)e);
            }
        }
        boolean jsr181Enabled = CxfEndpointUtils.hasWebServiceAnnotation(serviceClass);
        cfb.setJSR181Enabled(jsr181Enabled);
        return this.createClientFromClientFactoryBean((ClientProxyFactoryBean)(jsr181Enabled ? new JaxWsProxyFactoryBean((ClientFactoryBean)cfb) : new ClientProxyFactoryBean((ClientFactoryBean)cfb)));
    }

    private Client createClientFromClientFactoryBean(ClientProxyFactoryBean cfb) throws CamelException {
        Bus bus = null;
        if (this.endpoint.getApplicationContext() != null) {
            bus = this.endpoint.getCxfEndpointBean().getBus();
            if (CxfEndpointUtils.getSetDefaultBus(this.endpoint)) {
                BusFactory.setThreadDefaultBus((Bus)bus);
            }
        } else {
            bus = BusFactory.getThreadDefaultBus();
        }
        if (this.endpoint.isSpringContextEndpoint()) {
            CxfEndpointBean cxfEndpointBean = this.endpoint.getCxfEndpointBean();
            CxfEndpointUtils.checkServiceClass(cxfEndpointBean.getServiceClass());
            if (cfb == null) {
                cfb = CxfEndpointUtils.getClientFactoryBean(cxfEndpointBean.getServiceClass());
            }
            this.endpoint.configure(cfb);
        } else {
            CxfEndpointUtils.checkServiceClassName(this.endpoint.getServiceClass());
            try {
                Class serviceClass = ClassLoaderUtils.loadClass((String)this.endpoint.getServiceClass(), ((Object)((Object)this)).getClass());
                if (cfb == null) {
                    cfb = CxfEndpointUtils.getClientFactoryBean(serviceClass);
                }
                cfb.setAddress(this.endpoint.getAddress());
                if (null != this.endpoint.getServiceClass()) {
                    cfb.setServiceClass(ObjectHelper.loadClass((String)this.endpoint.getServiceClass()));
                }
                if (null != this.endpoint.getWsdlURL()) {
                    cfb.setWsdlURL(this.endpoint.getWsdlURL());
                }
            }
            catch (ClassNotFoundException e) {
                throw new CamelException((Throwable)e);
            }
            if (this.endpoint.getWsdlURL() != null) {
                cfb.setWsdlURL(this.endpoint.getWsdlURL());
            }
        }
        if (CxfEndpointUtils.getServiceName(this.endpoint) != null) {
            cfb.setServiceName(CxfEndpointUtils.getServiceName(this.endpoint));
        }
        if (CxfEndpointUtils.getPortName(this.endpoint) != null) {
            cfb.setEndpointName(CxfEndpointUtils.getPortName(this.endpoint));
        }
        if (this.dataFormat.equals((Object)DataFormat.MESSAGE)) {
            cfb.getFeatures().add(new MessageDataFormatFeature());
        } else if (this.dataFormat.equals((Object)DataFormat.PAYLOAD)) {
            cfb.getFeatures().add(new PayLoadDataFormatFeature());
        }
        cfb.setBus(bus);
        return ((ClientProxy)Proxy.getInvocationHandler(cfb.create())).getClient();
    }

    public void process(Exchange exchange) throws Exception {
        CxfExchange cxfExchange = (CxfExchange)this.endpoint.createExchange(exchange);
        this.process(cxfExchange);
        exchange.copyFrom((Exchange)cxfExchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(CxfExchange exchange) throws Exception {
        Message inMessage = CxfBinding.createCxfMessage(this.endpoint.getHeaderFilterStrategy(), exchange);
        exchange.setProperty("DATA_FORMAT", (Object)this.dataFormat);
        if (this.dataFormat.equals((Object)DataFormat.POJO)) {
            ArrayList parameters = (ArrayList)inMessage.getContent(List.class);
            if (parameters == null) {
                parameters = new ArrayList();
            }
            String operationName = (String)exchange.getIn().getHeader("operationName", String.class);
            String operationNameSpace = (String)exchange.getIn().getHeader("operationNameSpace", String.class);
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map<String, Object> responseContext = CxfBinding.propogateContext(inMessage, context);
            MessageImpl response = new MessageImpl();
            if (operationName == null) throw new RuntimeCamelException("Can't find the operation name in the message!");
            Object[] result = null;
            result = this.invokeClient(operationNameSpace, operationName, parameters, context);
            if (result != null) {
                response.setContent(List.class, (Object)new MessageContentsList(result));
            } else {
                response.setContent(List.class, (Object)new MessageContentsList());
            }
            CxfBinding.storeCXfResponseContext((Message)response, responseContext);
            CxfBinding.storeCxfResponse(this.endpoint.getHeaderFilterStrategy(), exchange, (Message)response);
            return;
        } else {
            org.apache.cxf.message.Exchange ex = exchange.getExchange();
            if (ex == null) {
                ex = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange");
                exchange.setExchange(ex);
            }
            if (ex == null) {
                ex = new ExchangeImpl();
                exchange.setExchange(ex);
            }
            assert (ex != null);
            InvokingContext invokingContext = (InvokingContext)ex.get(InvokingContext.class);
            if (invokingContext == null) {
                invokingContext = InvokingContextFactory.createContext(this.dataFormat);
                ex.put(InvokingContext.class, (Object)invokingContext);
            }
            Map<Class, Object> params = invokingContext.getRequestContent(inMessage);
            CxfClient cxfClient = (CxfClient)this.client;
            BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
            MessageImpl response = null;
            if (boi == null) {
                response = new MessageImpl();
            } else {
                org.apache.cxf.endpoint.Endpoint ep = (org.apache.cxf.endpoint.Endpoint)ex.get(org.apache.cxf.endpoint.Endpoint.class);
                response = ep.getBinding().createMessage();
            }
            response.setExchange(ex);
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map<String, Object> responseContext = CxfBinding.propogateContext(inMessage, context);
            Object result = cxfClient.dispatch(params, context, ex);
            ex.setOutMessage((Message)response);
            invokingContext.setResponseContent((Message)response, result);
            CxfBinding.storeCXfResponseContext((Message)response, responseContext);
            CxfBinding.storeCxfResponse(this.endpoint.getHeaderFilterStrategy(), exchange, (Message)response);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    private Object[] invokeClient(String operationNameSpace, String operationName, List parameters, Map<String, Object> context) throws Exception {
        QName operationQName = null;
        operationQName = operationNameSpace == null ? new QName(this.client.getEndpoint().getService().getName().getNamespaceURI(), operationName) : new QName(operationNameSpace, operationName);
        BindingOperationInfo op = this.client.getEndpoint().getEndpointInfo().getBinding().getOperation(operationQName);
        if (op == null) {
            throw new RuntimeCamelException("No operation found in the CXF client, the operation is " + operationQName);
        }
        if (!this.endpoint.isWrapped() && op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        Object[] result = this.client.invoke(op, parameters.toArray(), context);
        return result;
    }
}

