/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageInInterceptor<T extends Message>
extends AbstractPhaseInterceptor<T> {
    public AbstractMessageInInterceptor(String phase) {
        super(phase);
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }

    public void handleMessage(T message) throws Fault {
        Logger logger = this.getLogger();
        if (this.isFaultMessage(message)) {
            message.getInterceptorChain().abort();
            Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(message);
                return;
            }
        }
        Document document = this.createDOMMessage(message);
        Element payloadEl = (Element)document.getChildNodes().item(0);
        Exchange ex = message.getExchange();
        BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        if (boi == null) {
            BindingInfo bi = (BindingInfo)ex.get(BindingInfo.class);
            if (bi == null) {
                Endpoint ep = (Endpoint)ex.get(Endpoint.class);
                bi = ep.getEndpointInfo().getBinding();
                ex.put(BindingInfo.class, (Object)bi);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("AbstractRoutingMessageInInterceptor Infer BindingOperationInfo.");
            }
            if ((boi = this.getBindingOperation(message, document)) == null) {
                QName startQName = new QName(payloadEl.getNamespaceURI(), payloadEl.getLocalName());
                throw new Fault(new org.apache.cxf.common.i18n.Message("REQ_NOT_UNDERSTOOD", this.getLogger(), new Object[]{startQName}));
            }
            if (boi != null) {
                ex.put(BindingOperationInfo.class, (Object)boi);
                ex.put(OperationInfo.class, (Object)boi.getOperationInfo());
                ex.setOneWay(boi.getOperationInfo().isOneWay());
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("DOMInInterceptor- BindingOperation is:" + boi.getName());
                }
            }
        }
        BindingMessageInfo bmi = this.isRequestor((Message)message) ? boi.getOutput() : boi.getInput();
        List<Element> partList = this.getPartList(message, payloadEl, bmi);
        message.put(List.class, partList);
    }

    protected Document createDOMMessage(T message) {
        Document doc = null;
        try {
            if (this.getLogger().isLoggable(Level.INFO)) {
                this.getLogger().info("AbstractMessageInInterceptor Converting Stax Stream to DOM");
            }
            XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            doc = StaxUtils.read((XMLStreamReader)xsr);
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", this.getLogger(), new Object[0]), (Throwable)xe);
        }
        return doc;
    }

    protected abstract Logger getLogger();

    protected abstract boolean isFaultMessage(T var1);

    protected abstract BindingOperationInfo getBindingOperation(T var1, Document var2);

    protected abstract List<Element> getPartList(T var1, Element var2, BindingMessageInfo var3);
}

