/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfExchange;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.headers.DefaultMessageHeadersRelay;
import org.apache.camel.component.cxf.headers.MessageHeadersRelay;
import org.apache.camel.component.cxf.headers.SoapMessageHeadersRelay;
import org.apache.camel.component.cxf.spring.CxfEndpointBean;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpoint
extends DefaultEndpoint<CxfExchange> {
    private final CxfComponent component;
    private final String address;
    private String wsdlURL;
    private String serviceClass;
    private String portName;
    private String serviceName;
    private String dataFormat;
    private String beanId;
    private String serviceClassInstance;
    private boolean isWrapped;
    private boolean isSpringContextEndpoint;
    private boolean inOut = true;
    private boolean relayHeaders = true;
    private Boolean isSetDefaultBus;
    private ConfigurerImpl configurer;
    private CxfEndpointBean cxfEndpointBean;
    private Map<String, MessageHeadersRelay> ns2Relay = new HashMap<String, MessageHeadersRelay>();

    public CxfEndpoint(String uri, String address, CxfComponent component) {
        super(uri, (Component)component);
        this.component = component;
        this.address = address;
        if (address.startsWith("bean:")) {
            this.isSpringContextEndpoint = true;
            this.beanId = address.substring("bean:".length());
            if (this.beanId.startsWith("//")) {
                this.beanId = this.beanId.substring(2);
            }
            SpringCamelContext context = (SpringCamelContext)this.getCamelContext();
            this.configurer = new ConfigurerImpl(context.getApplicationContext());
            this.cxfEndpointBean = (CxfEndpointBean)((Object)context.getApplicationContext().getBean(this.beanId));
            ObjectHelper.notNull((Object)((Object)this.cxfEndpointBean), (String)"cxfEndpointBean");
        }
        this.initializeHeadersRelaysMap();
    }

    public Producer<CxfExchange> createProducer() throws Exception {
        return new CxfProducer(this);
    }

    public Consumer<CxfExchange> createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor);
    }

    public CxfExchange createExchange() {
        return new CxfExchange(this.getCamelContext(), this.getExchangePattern());
    }

    public CxfExchange createExchange(ExchangePattern pattern) {
        return new CxfExchange(this.getCamelContext(), pattern);
    }

    public CxfExchange createExchange(Message inMessage) {
        return new CxfExchange(this.getCamelContext(), this.getExchangePattern(), inMessage);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String format) {
        this.dataFormat = format;
    }

    public boolean isSpringContextEndpoint() {
        return this.isSpringContextEndpoint;
    }

    public String getAddress() {
        return this.address;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public void setSetDefaultBus(Boolean set) {
        this.isSetDefaultBus = set;
    }

    public Boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String className) {
        this.serviceClass = className;
    }

    public String getServiceClassInstance() {
        return this.serviceClassInstance;
    }

    public void setServiceClassInstance(String classInstance) {
        this.serviceClassInstance = classInstance;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isRelayHeaders() {
        return this.relayHeaders;
    }

    public void setRelayHeaders(boolean relayHeaders) {
        this.relayHeaders = relayHeaders;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.isWrapped = wrapped;
    }

    public CxfComponent getComponent() {
        return this.component;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public CxfEndpointBean getCxfEndpointBean() {
        return this.cxfEndpointBean;
    }

    public void configure(Object beanInstance) {
        AbstractApplicationContext context;
        if (((SpringCamelContext)this.getCamelContext()).getApplicationContext() instanceof AbstractApplicationContext && !(context = (AbstractApplicationContext)((SpringCamelContext)this.getCamelContext()).getApplicationContext()).isActive()) {
            context.refresh();
        }
        this.configurer.configureBean(this.beanId, beanInstance);
    }

    public ApplicationContext getApplicationContext() {
        if (this.getCamelContext() instanceof SpringCamelContext) {
            SpringCamelContext context = (SpringCamelContext)this.getCamelContext();
            return context.getApplicationContext();
        }
        return null;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.component.getHeaderFilterStrategy();
    }

    public void setMessageHeadersRelay(Collection<MessageHeadersRelay> relays) {
        HashMap<String, MessageHeadersRelay> localRelays = new HashMap<String, MessageHeadersRelay>();
        for (MessageHeadersRelay relay : relays) {
            CxfEndpoint.setMessageHeadersRelay(relay, localRelays, false);
        }
        this.ns2Relay.putAll(localRelays);
    }

    public Collection<MessageHeadersRelay> getMessageHeadersRelays() {
        ArrayList<MessageHeadersRelay> relays = new ArrayList<MessageHeadersRelay>();
        for (MessageHeadersRelay relay : this.ns2Relay.values()) {
            if (relays.contains(relay)) continue;
            relays.add(relay);
        }
        return relays;
    }

    public MessageHeadersRelay getMessageHeadersRelay(String ns) {
        return this.ns2Relay.get(ns);
    }

    protected void initializeHeadersRelaysMap() {
        ArrayList<MessageHeadersRelay> defaultRelays = new ArrayList<MessageHeadersRelay>();
        defaultRelays.addAll(Arrays.asList(new DefaultMessageHeadersRelay(), new SoapMessageHeadersRelay()));
        this.setMessageHeadersRelay(defaultRelays);
        if (this.cxfEndpointBean == null || this.cxfEndpointBean.getProperties() == null) {
            return;
        }
        Object v = this.cxfEndpointBean.getProperties().get("org.apache.camel.cxf.message.headers.relays");
        if (v == null || !(v instanceof Collection)) {
            return;
        }
        Collection c = (Collection)v;
        Collection relays = null;
        try {
            relays = CastUtils.cast((Collection)c);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The property org.apache.camel.cxf.message.headers.relays must have a list that consists of classes inherited from " + MessageHeadersRelay.class.getName());
        }
        this.setMessageHeadersRelay(relays);
    }

    private static void setMessageHeadersRelay(MessageHeadersRelay relay, Map<String, MessageHeadersRelay> ns2Relay, boolean allowClash) {
        for (String ns : relay.getActivationNamespaces()) {
            if (ns2Relay.containsKey(ns) && ns2Relay.get(ns) != relay && !allowClash) {
                throw new IllegalArgumentException("More then one MessageHeaderRelay activates for the same namespace: " + ns);
            }
            ns2Relay.put(ns, relay);
        }
    }
}

