/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfMessage;
import org.apache.camel.impl.DefaultExchange;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;

public class CxfExchange
extends DefaultExchange {
    private org.apache.cxf.message.Exchange exchange;

    public CxfExchange(CamelContext context, ExchangePattern pattern, org.apache.cxf.message.Exchange exchange) {
        super(context, pattern);
        this.exchange = exchange;
        if (exchange != null) {
            if (exchange.getOutMessage() != null) {
                this.setOut((Message)new CxfMessage(exchange.getOutMessage()));
            }
            if (exchange.getInMessage() != null) {
                this.setIn((Message)new CxfMessage(exchange.getInMessage()));
            }
            if (exchange.getInFaultMessage() != null) {
                this.setFault((Message)new CxfMessage(exchange.getInFaultMessage()));
            }
        }
    }

    public CxfExchange(CamelContext context, ExchangePattern pattern) {
        super(context, pattern);
    }

    public CxfExchange(CxfExchange exchange) {
        super((DefaultExchange)exchange);
        this.exchange = exchange.getExchange();
    }

    public CxfExchange(CamelContext context, ExchangePattern pattern, org.apache.cxf.message.Message inMessage) {
        this(context, pattern);
        this.exchange = inMessage.getExchange();
        this.setIn((Message)new CxfMessage(inMessage));
        if (this.exchange != null) {
            if (this.exchange.getOutMessage() != null) {
                this.setOut((Message)new CxfMessage(this.exchange.getOutMessage()));
            }
            if (this.exchange.getInFaultMessage() != null) {
                this.setFault((Message)new CxfMessage(this.exchange.getInFaultMessage()));
            }
        }
    }

    public Exchange newInstance() {
        return new CxfExchange(this);
    }

    protected Message createFaultMessage() {
        return new CxfMessage();
    }

    public void setExchange(org.apache.cxf.message.Exchange exchange) {
        this.exchange = exchange;
    }

    public org.apache.cxf.message.Exchange getExchange() {
        return this.exchange;
    }

    public org.apache.cxf.message.Message getInMessage() {
        if (this.getIn() instanceof CxfMessage) {
            return ((CxfMessage)this.getIn()).getMessage();
        }
        return null;
    }

    public org.apache.cxf.message.Message getOutMessage() {
        if (this.getOut() instanceof CxfMessage) {
            return ((CxfMessage)this.getOut()).getMessage();
        }
        return null;
    }

    public org.apache.cxf.message.Message getOutFaultMessage() {
        return this.getExchange().getOutFaultMessage();
    }

    public org.apache.cxf.message.Message getInFaultMessage() {
        return this.getExchange().getInFaultMessage();
    }

    public Destination getDestination() {
        return this.getExchange().getDestination();
    }

    public Conduit getConduit(org.apache.cxf.message.Message message) {
        return this.getExchange().getConduit(message);
    }

    protected Message createInMessage() {
        return new CxfMessage();
    }

    protected Message createOutMessage() {
        return new CxfMessage();
    }
}

