/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.CxfSoapEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;

public class CxfSoapComponent
extends DefaultComponent
implements HeaderFilterStrategyAware {
    private HeaderFilterStrategy headerFilterStrategy;

    public CxfSoapComponent() {
        this.setHeaderFilterStrategy((HeaderFilterStrategy)new CxfHeaderFilterStrategy());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        Map soapProps = IntrospectionSupport.extractProperties((Map)parameters, (String)"soap.");
        if (parameters.size() > 0) {
            remaining = remaining + "?" + URISupport.createQueryString((Map)parameters);
        }
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)this.getCamelContext(), (String)remaining);
        CxfSoapEndpoint soapEndpoint = new CxfSoapEndpoint(endpoint, this.getHeaderFilterStrategy());
        this.setProperties(soapEndpoint, soapProps);
        soapEndpoint.init();
        return soapEndpoint;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

