/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.soap.SOAPMessage;
import org.apache.camel.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.MessageContentsList;

@Converter
public final class CxfConverter {
    private static final Log LOG = LogFactory.getLog(CxfConverter.class);

    private CxfConverter() {
    }

    @Converter
    public static Object[] toArray(MessageContentsList list) throws Exception {
        if (list == null) {
            throw new IllegalArgumentException("The MessageChannel is null");
        }
        return list.toArray();
    }

    @Converter
    public static MessageContentsList toMessageContentsList(Object[] array) {
        if (array != null) {
            return new MessageContentsList(array);
        }
        return new MessageContentsList();
    }

    @Converter
    public static String soapMessageToString(SOAPMessage soapMessage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            soapMessage.writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            LOG.error((Object)("Get the exception when converting the SOAPMessage into String, the exception is " + e));
        }
        return baos.toString();
    }
}

