/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;

public class DataOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(DataOutInterceptor.class);

    public DataOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(Message message) throws Fault {
        XMLStreamWriter xmlWriter = this.getXMLStreamWriter(message);
        try {
            Source source = (Source)message.getContent(Source.class);
            if (source != null) {
                XMLStreamReader xmlReader = StaxUtils.createXMLStreamReader((Source)source);
                StaxUtils.copy((XMLStreamReader)xmlReader, (XMLStreamWriter)xmlWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XMLSTREAM_EXCEPTION", LOG, new Object[]{e}), (Throwable)e);
        }
    }
}

