/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.util.DataInInterceptor;
import org.apache.camel.component.cxf.util.DataOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapActionOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderOutFilterInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLSoapServiceFactoryBean
extends ReflectionServiceFactoryBean {
    private QName serviceName;
    private QName endpointName;

    public Service create() {
        WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), this.getWsdlURL(), this.getServiceQName());
        this.setService(factory.create());
        this.initializeSoapInterceptors();
        this.updateEndpointInfors();
        this.createEndpoints();
        return this.getService();
    }

    private void updateEndpointInfors() {
        Service service = this.getService();
        for (ServiceInfo inf : service.getServiceInfos()) {
            for (EndpointInfo ei : inf.getEndpoints()) {
                ei.setAddress("local://" + ei.getService().getName().toString() + "/" + ei.getName().getLocalPart());
            }
        }
    }

    protected void checkServiceClassAnnotations(Class<?> sc) {
    }

    private void initializeSoapInterceptors() {
        this.getService().getInInterceptors().add(new DataInInterceptor());
        this.getService().getInInterceptors().add(new ReadHeadersInterceptor(this.getBus()));
        this.getService().getInInterceptors().add(new CheckFaultInterceptor());
        this.getService().getInInterceptors().add(new MustUnderstandInterceptor());
        this.getService().getInInterceptors().add(new AttachmentInInterceptor());
        this.getService().getInInterceptors().add(new SoapHeaderInterceptor());
        this.getService().getInInterceptors().add(new CheckFaultInterceptor());
        this.getService().getInInterceptors().add(new URIMappingInterceptor());
        this.getService().getInInterceptors().add(new StaxInInterceptor());
        this.getService().getInInterceptors().add(new SoapActionInInterceptor());
        this.getService().getOutInterceptors().add(new DataOutInterceptor());
        this.getService().getOutInterceptors().add(new SoapActionOutInterceptor());
        this.getService().getOutInterceptors().add(new AttachmentOutInterceptor());
        this.getService().getOutInterceptors().add(new StaxOutInterceptor());
        this.getService().getOutInterceptors().add(new SoapHeaderOutFilterInterceptor());
        this.getService().getOutInterceptors().add(new SoapPreProtocolOutInterceptor());
        this.getService().getOutInterceptors().add(new SoapOutInterceptor(this.getBus()));
        this.getService().getOutFaultInterceptors().add(new SoapOutInterceptor(this.getBus()));
    }

    public void setServiceName(QName name) {
        this.serviceName = name;
    }

    public String getServiceName() {
        return this.serviceName.toString();
    }

    public QName getServiceQName() {
        return this.serviceName;
    }

    public QName getEndpointName() {
        if (this.endpointName == null) {
            this.endpointName = (QName)this.getService().getEndpoints().keySet().iterator().next();
        }
        return this.endpointName;
    }

    public void setEndpointName(QName name) {
        this.endpointName = name;
    }
}

