/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.annotation.Annotation;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.apache.camel.component.cxf.util.WSDLSoapServiceFactoryBean;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class CxfEndpointUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CxfEndpointUtils.class);

    private CxfEndpointUtils() {
    }

    public static QName getQName(String name) {
        QName qName = null;
        if (name != null) {
            try {
                qName = QName.valueOf(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return qName;
    }

    public static QName getPortName(CxfEndpoint endpoint) {
        if (endpoint.getPortName() != null) {
            return endpoint.getPortName();
        }
        String portLocalName = CxfEndpointUtils.getCxfEndpointPropertyValue((CxfSpringEndpoint)endpoint, "endpointLocalName");
        String portNamespace = CxfEndpointUtils.getCxfEndpointPropertyValue((CxfSpringEndpoint)endpoint, "endpointNamespace");
        if (portLocalName != null) {
            return new QName(portNamespace, portLocalName);
        }
        return null;
    }

    public static QName getServiceName(CxfEndpoint endpoint) {
        if (endpoint.getServiceName() != null) {
            return endpoint.getServiceName();
        }
        String serviceLocalName = CxfEndpointUtils.getCxfEndpointPropertyValue((CxfSpringEndpoint)endpoint, "serviceLocalName");
        String serviceNamespace = CxfEndpointUtils.getCxfEndpointPropertyValue((CxfSpringEndpoint)endpoint, "serviceNamespace");
        if (serviceLocalName != null) {
            return new QName(serviceNamespace, serviceLocalName);
        }
        return null;
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        return CxfEndpointUtils.hasAnnotation(cls, WebService.class) || CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class);
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls == null || cls == Object.class) {
            return false;
        }
        if (null != cls.getAnnotation(annotation)) {
            return true;
        }
        for (Class<?> interfaceClass : cls.getInterfaces()) {
            if (null == interfaceClass.getAnnotation(annotation)) continue;
            return true;
        }
        return CxfEndpointUtils.hasAnnotation(cls.getSuperclass(), annotation);
    }

    public static ServerFactoryBean getServerFactoryBean(Class<?> cls) throws CamelException {
        ServerFactoryBean serverFactory = null;
        try {
            if (cls == null) {
                serverFactory = new ServerFactoryBean();
                serverFactory.setServiceFactory((ReflectionServiceFactoryBean)new WSDLSoapServiceFactoryBean());
            } else {
                boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
                serverFactory = isJSR181SEnabled ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
            }
            return serverFactory;
        }
        catch (Exception e) {
            throw new CamelException((Throwable)e);
        }
    }

    public static ClientProxyFactoryBean getClientFactoryBean(Class<?> cls) throws CamelException {
        ClientProxyFactoryBean clientFactory = null;
        try {
            if (cls == null) {
                clientFactory = new ClientProxyFactoryBean();
                clientFactory.setServiceFactory((ReflectionServiceFactoryBean)new WSDLSoapServiceFactoryBean());
            } else {
                boolean isJSR181SEnabled = CxfEndpointUtils.hasWebServiceAnnotation(cls);
                clientFactory = isJSR181SEnabled ? new JaxWsProxyFactoryBean() : new ClientProxyFactoryBean();
            }
            return clientFactory;
        }
        catch (Exception e) {
            throw new CamelException((Throwable)e);
        }
    }

    public static void checkServiceClassName(String className) throws CamelException {
        if (ObjectHelper.isEmpty((Object)className)) {
            throw new CamelException("serviceClass is required for CXF endpoint configuration");
        }
    }

    public static String getCxfEndpointPropertyValue(CxfSpringEndpoint endpoint, String property) {
        return (String)endpoint.getProperties().get(property);
    }

    public static String getEffectiveAddress(Exchange exchange, String defaultAddress) {
        String retval = (String)exchange.getIn().getHeader("CamelDestinationOverrideUrl", String.class);
        if (retval == null) {
            retval = defaultAddress;
        } else {
            LOG.trace("Client address is overridden by header '{}' to value '{}'", (Object)"CamelDestinationOverrideUrl", (Object)retval);
        }
        return retval;
    }

    public static Bus createBus(CamelContext context) {
        BusFactory busFactory = BusFactory.newInstance();
        if (context instanceof SpringCamelContext) {
            SpringCamelContext springCamelContext = (SpringCamelContext)context;
            ApplicationContext applicationContext = springCamelContext.getApplicationContext();
            busFactory = new SpringBusFactory(applicationContext);
        }
        return busFactory.createBus();
    }
}

