/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.transport.CamelConduit;
import org.apache.camel.component.cxf.transport.CamelDestination;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/camel";
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private Collection<String> activationNamespaces;
    private HeaderFilterStrategy headerFilterStrategy;
    private boolean checkException;
    private Bus bus;
    private CamelContext camelContext;

    public CamelTransportFactory() {
        CxfHeaderFilterStrategy defaultHeaderFilterStrategy = new CxfHeaderFilterStrategy();
        defaultHeaderFilterStrategy.setOutFilterPattern(null);
        this.headerFilterStrategy = defaultHeaderFilterStrategy;
    }

    @Resource(name="bus")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Resource(name="camelContext")
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setCheckException(boolean check) {
        this.checkException = check;
    }

    public boolean isCheckException() {
        return this.checkException;
    }

    public Conduit getConduit(EndpointInfo targetInfo) throws IOException {
        return this.getConduit(targetInfo, null);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        return new CamelConduit(this.camelContext, this.bus, endpointInfo, target, this.headerFilterStrategy);
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        return new CamelDestination(this.camelContext, this.bus, this, endpointInfo, this.headerFilterStrategy, this.checkException);
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    @PostConstruct
    void registerWithBindingManager() {
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        if (null != cim && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, (ConduitInitiator)this);
            }
        }
        if (null != (dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)) && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, (DestinationFactory)this);
            }
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    static {
        URI_PREFIXES.add("camel://");
    }
}

