/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.version.Version;

public class CxfRsInvoker
extends JAXRSInvoker {
    private static final Log LOG = LogFactory.getLog(CxfRsInvoker.class);
    private static final String SUSPENED = "org.apache.camel.component.cxf.jaxrs.suspend";
    private static final String SERVICE_OBJECT_SCOPE = "org.apache.cxf.service.scope";
    private static final String REQUEST_SCOPE = "request";
    private CxfRsConsumer cxfRsConsumer;
    private CxfRsEndpoint endpoint;

    public CxfRsInvoker(CxfRsEndpoint endpoint, CxfRsConsumer consumer) {
        this.endpoint = endpoint;
        this.cxfRsConsumer = consumer;
    }

    protected Object performInvocation(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray) throws Exception {
        Continuation continuation;
        paramArray = this.insertExchange(method, paramArray, cxfExchange);
        OperationResourceInfo ori = (OperationResourceInfo)cxfExchange.get(OperationResourceInfo.class);
        if (ori.isSubResourceLocator()) {
            return method.invoke(serviceObject, paramArray);
        }
        if (!this.endpoint.isSynchronous() && (continuation = this.getContinuation(cxfExchange)) != null && Version.getCurrentVersion().startsWith("2.3")) {
            return this.asyncInvoke(cxfExchange, serviceObject, method, paramArray, continuation);
        }
        return this.syncInvoke(cxfExchange, serviceObject, method, paramArray);
    }

    private Continuation getContinuation(org.apache.cxf.message.Exchange cxfExchange) {
        ContinuationProvider provider = (ContinuationProvider)cxfExchange.getInMessage().get((Object)ContinuationProvider.class.getName());
        return provider == null ? null : provider.getContinuation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object asyncInvoke(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray, final Continuation continuation) throws Exception {
        Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.isNew()) {
                ExchangePattern ep = ExchangePattern.InOut;
                if (method.getReturnType() == Void.class) {
                    ep = ExchangePattern.InOnly;
                }
                final Exchange camelExchange = this.endpoint.createExchange(ep);
                CxfRsBinding binding = this.endpoint.getBinding();
                binding.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Suspending continuation of exchangeId: " + camelExchange.getExchangeId()));
                }
                continuation.suspend(0L);
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.TRUE);
                this.cxfRsConsumer.getAsyncProcessor().process(camelExchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(boolean doneSync) {
                        Continuation continuation2 = continuation;
                        synchronized (continuation2) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("Resuming continuation of exchangeId: " + camelExchange.getExchangeId()));
                            }
                            continuation.setObject((Object)camelExchange);
                            continuation.resume();
                        }
                    }
                });
                return null;
            }
            if (continuation.isResumed()) {
                cxfExchange.put((Object)SUSPENED, (Object)Boolean.FALSE);
                Exchange camelExchange = (Exchange)continuation.getObject();
                return this.returnResponse(cxfExchange, camelExchange);
            }
        }
        return null;
    }

    private Object syncInvoke(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray) throws Exception {
        ExchangePattern ep = ExchangePattern.InOut;
        if (method.getReturnType() == Void.class) {
            ep = ExchangePattern.InOnly;
        }
        Exchange camelExchange = this.endpoint.createExchange(ep);
        CxfRsBinding binding = this.endpoint.getBinding();
        binding.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
        try {
            this.cxfRsConsumer.getProcessor().process(camelExchange);
        }
        catch (Exception exception) {
            camelExchange.setException((Throwable)exception);
        }
        return this.returnResponse(cxfExchange, camelExchange);
    }

    private Object returnResponse(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) throws Exception {
        if (camelExchange.getException() != null) {
            Throwable exception = camelExchange.getException();
            Response result = null;
            if (exception instanceof RuntimeCamelException && exception.getCause() != null) {
                exception = exception.getCause();
            }
            if (exception instanceof WebApplicationException) {
                result = ((WebApplicationException)exception).getResponse();
                if (result != null) {
                    return result;
                }
                throw (WebApplicationException)exception;
            }
            WebApplicationException webApplicationException = new WebApplicationException(exception, Response.serverError().entity((Object)exception.toString()).build());
            throw webApplicationException;
        }
        return this.endpoint.getBinding().populateCxfRsResponseFromExchange(camelExchange, cxfExchange);
    }
}

