/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.ws.WebServiceProvider;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.CxfProducer;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultCxfBinding;
import org.apache.camel.component.cxf.HybridSourceDataBinding;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.component.cxf.feature.MessageDataFormatFeature;
import org.apache.camel.component.cxf.feature.PayLoadDataFormatFeature;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service {
    private static final Log LOG = LogFactory.getLog(CxfEndpoint.class);
    private String wsdlURL;
    private String serviceClass;
    private String portName;
    private String serviceName;
    private String defaultOperationName;
    private String defaultOperationNamespace;
    private DataFormat dataFormat = DataFormat.POJO;
    private boolean isWrapped;
    private Boolean wrappedStyle;
    private String publishedEndpointUrl;
    private boolean inOut = true;
    private Bus bus;
    private CxfBinding cxfBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    private AtomicBoolean getBusHasBeenCalled = new AtomicBoolean(false);
    private boolean isSetDefaultBus;
    private boolean loggingFeatureEnabled;
    private String address;
    private boolean mtomEnabled;
    private Map<String, Object> properties;

    public CxfEndpoint(String remaining, CxfComponent cxfComponent) {
        super(remaining, (Component)cxfComponent);
        this.setAddress(remaining);
    }

    public CxfEndpoint(String remaining, CamelContext context) {
        super(remaining, context);
        this.setAddress(remaining);
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public Producer createProducer() throws Exception {
        CxfProducer answer = new CxfProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void setupServerFactoryBean(ServerFactoryBean sfb, Class<?> cls) {
        sfb.setAddress(this.getAddress());
        sfb.setServiceClass(cls);
        if (this.getWsdlURL() != null) {
            sfb.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            sfb.setServiceName(CxfEndpointUtils.getQName(this.getServiceName()));
        }
        if (this.getPortName() != null) {
            sfb.setEndpointName(CxfEndpointUtils.getQName(this.getPortName()));
        }
        if (!CxfEndpointUtils.hasAnnotation(cls, WebServiceProvider.class)) {
            if (this.getDataFormat() == DataFormat.PAYLOAD) {
                sfb.getFeatures().add(new PayLoadDataFormatFeature());
            } else if (this.getDataFormat() == DataFormat.MESSAGE) {
                sfb.getFeatures().add(new MessageDataFormatFeature());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ignore DataFormat mode " + (Object)((Object)this.getDataFormat()) + " since SEI class is annotated with WebServiceProvider"));
        }
        if (this.loggingFeatureEnabled) {
            sfb.getFeatures().add(new LoggingFeature());
        }
        if (this.getDataFormat() == DataFormat.PAYLOAD) {
            sfb.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.getWrappedStyle() != null) {
            sfb.getServiceFactory().setWrapped(this.getWrappedStyle().booleanValue());
        }
        if (this.getProperties() != null) {
            if (sfb.getProperties() != null) {
                sfb.getProperties().putAll(this.getProperties());
            } else {
                sfb.setProperties(this.getProperties());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ServerFactoryBean: " + sfb + " added properties: " + this.properties));
            }
        }
        sfb.setBus(this.getBus());
        sfb.setStart(false);
    }

    protected ClientProxyFactoryBean createClientFactoryBean(Class<?> cls) throws CamelException {
        if (CxfEndpointUtils.hasWebServiceAnnotation(cls)) {
            return new JaxWsProxyFactoryBean((ClientFactoryBean)new JaxWsClientFactoryBean(){

                protected Client createClient(Endpoint ep) {
                    return new CamelCxfClientImpl(this.getBus(), ep);
                }
            });
        }
        return new ClientProxyFactoryBean(new ClientFactoryBean(){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }
        });
    }

    protected ClientFactoryBean createClientFactoryBean() {
        return new ClientFactoryBean(new WSDLServiceFactoryBean()){

            protected Client createClient(Endpoint ep) {
                return new CamelCxfClientImpl(this.getBus(), ep);
            }

            protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> cls) {
            }
        };
    }

    protected Bus doGetBus() {
        BusFactory busFactory = BusFactory.newInstance();
        if (this.getCamelContext() instanceof SpringCamelContext) {
            SpringCamelContext springCamelContext = (SpringCamelContext)this.getCamelContext();
            ApplicationContext applicationContext = springCamelContext.getApplicationContext();
            busFactory = new SpringBusFactory(applicationContext);
        }
        return busFactory.createBus();
    }

    protected void setupClientFactoryBean(ClientProxyFactoryBean factoryBean, Class<?> cls) {
        factoryBean.setServiceClass(cls);
        factoryBean.setAddress(this.getAddress());
        if (this.getWsdlURL() != null) {
            factoryBean.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            factoryBean.setServiceName(CxfEndpointUtils.getQName(this.getServiceName()));
        }
        if (this.getPortName() != null) {
            factoryBean.setEndpointName(CxfEndpointUtils.getQName(this.getPortName()));
        }
        if (this.getDataFormat() == DataFormat.MESSAGE) {
            factoryBean.getFeatures().add(new MessageDataFormatFeature());
        } else if (this.getDataFormat() == DataFormat.PAYLOAD) {
            factoryBean.getFeatures().add(new PayLoadDataFormatFeature());
            factoryBean.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.loggingFeatureEnabled) {
            factoryBean.getFeatures().add(new LoggingFeature());
        }
        if (this.getWrappedStyle() != null) {
            factoryBean.getServiceFactory().setWrapped(this.getWrappedStyle().booleanValue());
        }
        if (this.getProperties() != null) {
            if (factoryBean.getProperties() != null) {
                factoryBean.getProperties().putAll(this.getProperties());
            } else {
                factoryBean.setProperties(this.getProperties());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ClientProxyFactoryBean: " + factoryBean + " added properties: " + this.properties));
            }
        }
        factoryBean.setBus(this.getBus());
    }

    protected void setupClientFactoryBean(ClientFactoryBean factoryBean) {
        factoryBean.setAddress(this.getAddress());
        if (this.getWsdlURL() != null) {
            factoryBean.setWsdlURL(this.getWsdlURL());
        }
        if (this.getServiceName() != null) {
            factoryBean.setServiceName(CxfEndpointUtils.getQName(this.getServiceName()));
        }
        if (this.getPortName() != null) {
            factoryBean.setEndpointName(CxfEndpointUtils.getQName(this.getPortName()));
        }
        if (this.getDataFormat() == DataFormat.MESSAGE) {
            factoryBean.getFeatures().add(new MessageDataFormatFeature());
        } else if (this.getDataFormat() == DataFormat.PAYLOAD) {
            factoryBean.getFeatures().add(new PayLoadDataFormatFeature());
            factoryBean.setDataBinding((DataBinding)new HybridSourceDataBinding());
        }
        if (this.loggingFeatureEnabled) {
            factoryBean.getFeatures().add(new LoggingFeature());
        }
        if (this.getWrappedStyle() != null) {
            factoryBean.getServiceFactory().setWrapped(this.getWrappedStyle().booleanValue());
        }
        factoryBean.setBus(this.getBus());
    }

    Client createClient() throws Exception {
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notEmpty((String)this.getServiceClass(), (String)"serviceClass");
        }
        Class cls = null;
        if (this.getServiceClass() != null) {
            cls = ClassLoaderUtils.loadClass((String)this.getServiceClass(), ((Object)((Object)this)).getClass());
            ClientProxyFactoryBean factoryBean = this.createClientFactoryBean(cls);
            this.setupClientFactoryBean(factoryBean, cls);
            return ((ClientProxy)Proxy.getInvocationHandler(factoryBean.create())).getClient();
        }
        this.checkName(this.portName, "endpoint/port name");
        this.checkName(this.serviceName, "service name");
        ClientFactoryBean factoryBean = this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean);
        return factoryBean.create();
    }

    void checkName(Object value, String name) {
        if (ObjectHelper.isEmpty((Object)value)) {
            LOG.warn((Object)("The " + name + " of " + this.getEndpointUri() + " is empty, cxf will try to load the first one in wsdl for you."));
        }
    }

    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class cls = null;
        if (this.getDataFormat() == DataFormat.POJO || this.getServiceClass() != null) {
            ObjectHelper.notEmpty((String)this.getServiceClass(), (String)"serviceClass");
            cls = ClassLoaderUtils.loadClass((String)this.getServiceClass(), ((Object)((Object)this)).getClass());
        }
        Object answer = null;
        if (cls == null) {
            this.checkName(this.portName, " endpoint/port name");
            this.checkName(this.serviceName, " service name");
            answer = new ServerFactoryBean((ReflectionServiceFactoryBean)new WSDLServiceFactoryBean());
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean((ServerFactoryBean)answer, cls);
        return answer;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public String getPublishedEndpointUrl() {
        return this.publishedEndpointUrl;
    }

    public void setPublishedEndpointUrl(String url) {
        this.publishedEndpointUrl = url;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String url) {
        this.wsdlURL = url;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String className) {
        this.serviceClass = className;
    }

    public void setServiceClass(Object instance) {
        this.serviceClass = ClassHelper.getRealClass((Object)instance).getName();
    }

    public void setServiceName(String service) {
        this.serviceName = service;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String port) {
        this.portName = port;
    }

    public String getDefaultOperationName() {
        return this.defaultOperationName;
    }

    public void setDefaultOperationName(String name) {
        this.defaultOperationName = name;
    }

    public String getDefaultOperationNamespace() {
        return this.defaultOperationNamespace;
    }

    public void setDefaultOperationNamespace(String namespace) {
        this.defaultOperationNamespace = namespace;
    }

    public boolean isInOut() {
        return this.inOut;
    }

    public void setInOut(boolean inOut) {
        this.inOut = inOut;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.isWrapped = wrapped;
    }

    public Boolean getWrappedStyle() {
        return this.wrappedStyle;
    }

    public void setWrappedStyle(Boolean wrapped) {
        this.wrappedStyle = wrapped;
    }

    public void setCxfBinding(CxfBinding cxfBinding) {
        this.cxfBinding = cxfBinding;
    }

    public CxfBinding getCxfBinding() {
        return this.cxfBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = this.doGetBus();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using DefaultBus " + this.bus));
            }
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Set bus " + this.bus + " as thread default bus"));
            }
        }
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfHeaderFilterStrategy();
        }
        if (this.cxfBinding == null) {
            this.cxfBinding = new DefaultCxfBinding();
        }
        if (this.cxfBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.cxfBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    protected void doStop() throws Exception {
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    class CamelCxfClientImpl
    extends ClientImpl {
        public CamelCxfClientImpl(Bus bus, Endpoint ep) {
            super(bus, ep);
        }

        public Bus getBus() {
            return this.bus;
        }

        protected void setParameters(Object[] params, Message message) {
            Object attachements = message.get((Object)"CamelAttachments");
            if (attachements != null) {
                message.setAttachments((Collection)attachements);
                message.remove((Object)"CamelAttachments");
            }
            if (DataFormat.PAYLOAD == message.get(DataFormat.class)) {
                CxfPayload payload = (CxfPayload)params[0];
                List<Element> elements = payload.getBody();
                BindingOperationInfo boi = (BindingOperationInfo)message.get(BindingOperationInfo.class);
                MessageContentsList content = new MessageContentsList();
                int i = 0;
                for (MessagePartInfo partInfo : boi.getInput().getMessageParts()) {
                    if (elements.size() <= i || !partInfo.getConcreteName().getLocalPart().equals(elements.get(i).getLocalName())) continue;
                    content.put(partInfo, (Object)elements.get(i++));
                }
                message.setContent(List.class, (Object)content);
                message.put((Object)Header.HEADER_LIST, payload.getHeaders());
            } else {
                super.setParameters(params, message);
            }
            message.remove(DataFormat.class);
        }
    }
}

