/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfOperationException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.util.CxfEndpointUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.LRUCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfRsProducer
extends DefaultProducer {
    private static final Log LOG = LogFactory.getLog(CxfRsProducer.class);
    private boolean throwException;
    private ClientFactoryBeanCache clientFactoryBeanCache;

    public CxfRsProducer(CxfRsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.clientFactoryBeanCache = new ClientFactoryBeanCache(endpoint.getMaxClientCacheSize());
    }

    public void process(Exchange exchange) throws Exception {
        Message inMessage;
        Boolean httpClientAPI;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process exchange: " + exchange));
        }
        if ((httpClientAPI = (Boolean)(inMessage = exchange.getIn()).getHeader("CamelCxfRsUsingHttpAPI", Boolean.class)) == null) {
            httpClientAPI = ((CxfRsEndpoint)this.getEndpoint()).isHttpClientAPI();
        }
        if (httpClientAPI.booleanValue()) {
            this.invokeHttpClient(exchange);
        } else {
            this.invokeProxyClient(exchange);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void invokeHttpClient(Exchange exchange) throws Exception {
        Integer respCode;
        void var13_17;
        Message inMessage = exchange.getIn();
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        WebClient client = cfb.createWebClient();
        String httpMethod = (String)inMessage.getHeader("CamelHttpMethod", String.class);
        Class responseClass = (Class)inMessage.getHeader("CamelCxfRsResponseClass", Class.class);
        Type genericType = (Type)inMessage.getHeader("CamelCxfRsResponseGenericType", Type.class);
        String path = (String)inMessage.getHeader("CamelHttpPath", String.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP method = " + httpMethod));
            LOG.trace((Object)("path = " + path));
            LOG.trace((Object)("responseClass = " + responseClass));
        }
        if (path != null) {
            client.path((Object)path);
        }
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        Map<String, String> maps = (Map<String, String>)inMessage.getHeader("CamelCxfRsQueryMap", Map.class);
        if (maps == null) {
            maps = cxfRsEndpoint.getParameters();
        }
        if (maps != null) {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                client.query(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        Object body = null;
        if (!"GET".equals(httpMethod)) {
            body = binding.bindCamelMessageBodyToRequestBody(inMessage, exchange);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Request body = " + body));
            }
        }
        client.headers(binding.bindCamelHeadersToRequestHeaders(inMessage.getHeaders(), exchange));
        Object var13_13 = null;
        if (responseClass == null || Response.class.equals((Object)responseClass)) {
            Response response = client.invoke(httpMethod, body);
        } else if (Collection.class.isAssignableFrom(responseClass)) {
            if (!(genericType instanceof ParameterizedType)) throw new CamelException("Can't find the Collection member type");
            Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            Collection collection = client.invokeAndGetCollection(httpMethod, body, (Class)actualTypeArguments[0]);
        } else {
            Object object = client.invoke(httpMethod, body, responseClass);
        }
        if (this.throwException && var13_17 instanceof Response && (respCode = Integer.valueOf(((Response)var13_17).getStatus())) > 207) {
            throw this.populateCxfRsProducerException(exchange, (Response)var13_17, respCode);
        }
        if (!exchange.getPattern().isOutCapable()) return;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Response body = " + var13_17));
        }
        exchange.getOut().setBody(binding.bindResponseToCamelBody(var13_17, exchange));
        exchange.getOut().setHeaders(binding.bindResponseHeadersToCamelHeaders(var13_17, exchange));
    }

    protected void invokeProxyClient(Exchange exchange) throws Exception {
        Integer respCode;
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        Client target = null;
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        target = varValues == null ? cfb.create() : cfb.createWithValues(varValues);
        JAXRSServiceFactoryBean sfb = cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = null;
        if (inMessage.getBody() != null) {
            parameters = (Object[])inMessage.getBody(Object[].class);
        }
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        Object response = method.invoke((Object)target, parameters);
        if (this.throwException && response instanceof Response && (respCode = Integer.valueOf(((Response)response).getStatus())) > 207) {
            throw this.populateCxfRsProducerException(exchange, (Response)response, respCode);
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().setBody(response);
        }
    }

    private Method findRightMethod(List<Class<?>> resourceClasses, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Method answer = null;
        for (Class<?> clazz : resourceClasses) {
            try {
                answer = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            if (answer == null) continue;
            return answer;
        }
        throw new NoSuchMethodException("Can find the method " + methodName + "withe these parameter " + this.arrayToString(parameterTypes));
    }

    private Class<?>[] getParameterTypes(Object[] objects) {
        if (objects == null) {
            return new Class[0];
        }
        Class[] answer = new Class[objects.length];
        int i = 0;
        for (Object obj : objects) {
            answer[i] = obj.getClass();
            ++i;
        }
        return answer;
    }

    private String arrayToString(Object[] array) {
        StringBuilder buffer = new StringBuilder("[");
        for (Object obj : array) {
            if (buffer.length() > 2) {
                buffer.append(",");
            }
            buffer.append(obj.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected CxfOperationException populateCxfRsProducerException(Exchange exchange, Response response, int responseCode) {
        CxfOperationException exception;
        String uri = exchange.getFromEndpoint().getEndpointUri();
        String statusText = Response.Status.fromStatusCode((int)responseCode).toString();
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        String copy = response.toString();
        LOG.warn(headers);
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getMetadata().getFirst((Object)"Location") != null) {
                String redirectLocation = response.getMetadata().getFirst((Object)"location").toString();
                exception = new CxfOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new CxfOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new CxfOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getMetadata().entrySet()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Parse external header " + (String)entry.getKey() + "=" + entry.getValue()));
                }
                LOG.info((Object)("Parse external header " + (String)entry.getKey() + "=" + entry.getValue()));
                answer.put((String)entry.getKey(), ((List)entry.getValue()).get(0).toString());
            }
        }
        return answer;
    }

    private class ClientFactoryBeanCache {
        private LRUCache<String, SoftReference<JAXRSClientFactoryBean>> cache;

        public ClientFactoryBeanCache(int maxCacheSize) {
            this.cache = new LRUCache(maxCacheSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JAXRSClientFactoryBean get(String address) throws Exception {
            JAXRSClientFactoryBean retval = null;
            LRUCache<String, SoftReference<JAXRSClientFactoryBean>> lRUCache = this.cache;
            synchronized (lRUCache) {
                SoftReference ref = (SoftReference)this.cache.get((Object)address);
                if (ref != null) {
                    retval = (JAXRSClientFactoryBean)ref.get();
                }
                if (retval == null) {
                    retval = ((CxfRsEndpoint)CxfRsProducer.this.getEndpoint()).createJAXRSClientFactoryBean(address);
                    this.cache.put((Object)address, new SoftReference<JAXRSClientFactoryBean>(retval));
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Created client factory bean and add to cache for address '" + address + "'"));
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Retrieved client factory bean from cache for address '" + address + "'"));
                }
            }
            return retval;
        }
    }
}

