/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.component.cxf.util.CxfMessageHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class CamelConduit
extends AbstractConduit
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-conduit";
    private static final Logger LOG = LogUtils.getL7dLogger(CamelConduit.class);
    private CamelContext camelContext;
    private EndpointInfo endpointInfo;
    private String targetCamelEndpointUri;
    private Producer producer;
    private ProducerTemplate camelTemplate;
    private Bus bus;
    private HeaderFilterStrategy headerFilterStrategy;

    public CamelConduit(CamelContext context, Bus b, EndpointInfo endpointInfo) {
        this(context, b, endpointInfo, null);
    }

    public CamelConduit(CamelContext context, Bus b, EndpointInfo epInfo, EndpointReferenceType targetReference) {
        this(context, b, epInfo, targetReference, null);
    }

    public CamelConduit(CamelContext context, Bus b, EndpointInfo epInfo, EndpointReferenceType targetReference, HeaderFilterStrategy headerFilterStrategy) {
        super(CamelConduit.getTargetReference((EndpointInfo)epInfo, (EndpointReferenceType)targetReference, (Bus)b));
        String address = epInfo.getAddress();
        if (address != null) {
            this.targetCamelEndpointUri = address.substring("camel:".length());
            if (this.targetCamelEndpointUri.startsWith("//")) {
                this.targetCamelEndpointUri = this.targetCamelEndpointUri.substring(2);
            }
        }
        this.camelContext = context;
        this.endpointInfo = epInfo;
        this.bus = b;
        this.initConfig();
        this.headerFilterStrategy = headerFilterStrategy;
        Endpoint target = this.getCamelContext().getEndpoint(this.targetCamelEndpointUri);
        try {
            this.producer = target.createProducer();
            this.producer.start();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot create the producer rightly", (Throwable)e);
        }
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public CamelContext getCamelContext() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        return this.camelContext;
    }

    public void prepare(Message message) throws IOException {
        this.getLogger().log(Level.FINE, "CamelConduit send message");
        message.setContent(OutputStream.class, (Object)new CamelOutputStream(message));
    }

    public void close() {
        this.getLogger().log(Level.FINE, "CamelConduit closed ");
        try {
            this.producer.stop();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "CamelConduit producer stop with the exception", e);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public String getBeanName() {
        if (this.endpointInfo == null || this.endpointInfo.getName() == null) {
            return "default.camel-conduit";
        }
        return this.endpointInfo.getName().toString() + BASE_BEAN_NAME_SUFFIX;
    }

    private void initConfig() {
        Configurer configurer;
        if (this.bus != null && null != (configurer = (Configurer)this.bus.getExtension(Configurer.class))) {
            configurer.configureBean((Object)this);
        }
    }

    @Deprecated
    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.getCamelContext().createProducerTemplate();
        }
        return this.camelTemplate;
    }

    @Deprecated
    public void setCamelTemplate(ProducerTemplate template) {
        this.camelTemplate = template;
    }

    @Deprecated
    protected class DecoupledDestination
    implements Destination {
        protected MessageObserver decoupledMessageObserver;
        private EndpointReferenceType address;

        DecoupledDestination(EndpointReferenceType ref, MessageObserver incomingObserver) {
            this.address = ref;
            this.decoupledMessageObserver = incomingObserver;
        }

        public EndpointReferenceType getAddress() {
            return this.address;
        }

        public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType addr) throws IOException {
            return null;
        }

        public void shutdown() {
        }

        public synchronized void setMessageObserver(MessageObserver observer) {
            this.decoupledMessageObserver = observer;
        }

        public synchronized MessageObserver getMessageObserver() {
            return this.decoupledMessageObserver;
        }
    }

    private class CamelOutputStream
    extends CachedOutputStream {
        private Message outMessage;
        private boolean isOneWay;

        public CamelOutputStream(Message m) {
            this.outMessage = m;
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.isOneWay = this.outMessage.getExchange().isOneWay();
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }

        private void commitOutputMessage() throws IOException {
            ExchangePattern pattern = this.isOneWay ? ExchangePattern.InOnly : ExchangePattern.InOut;
            CamelConduit.this.getLogger().log(Level.FINE, "send the message to endpoint" + CamelConduit.this.targetCamelEndpointUri);
            Exchange exchange = CamelConduit.this.producer.createExchange(pattern);
            exchange.setProperty("CamelToEndpoint", (Object)CamelConduit.this.targetCamelEndpointUri);
            CachedOutputStream outputStream = (CachedOutputStream)this.outMessage.getContent(OutputStream.class);
            CxfHeaderHelper.propagateCxfToCamel(CamelConduit.this.headerFilterStrategy, this.outMessage, exchange.getIn().getHeaders(), exchange);
            exchange.getIn().setBody((Object)outputStream.getBytes());
            CamelConduit.this.getLogger().log(Level.FINE, "template sending request: ", exchange.getIn());
            Exception exception = null;
            try {
                CamelConduit.this.producer.process(exchange);
            }
            catch (Exception ex) {
                exception = ex;
            }
            exception = exchange.getException();
            if (exception != null) {
                throw IOHelper.createIOException((String)"Can't send the request message.", (Throwable)exchange.getException());
            }
            exchange.setProperty("org.apache.cxf.message.exchange", (Object)this.outMessage.getExchange());
            if (!this.isOneWay) {
                this.handleResponse(exchange);
            }
        }

        private void handleResponse(Exchange exchange) throws IOException {
            Message inMessage = null;
            try {
                inMessage = CxfMessageHelper.getCxfInMessage(CamelConduit.this.headerFilterStrategy, exchange, true);
            }
            catch (Exception ex) {
                throw IOHelper.createIOException((String)"Can't get the response message. ", (Throwable)ex);
            }
            CamelConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

