/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.slf4j.Logger;

public abstract class AbstractDataFormatFeature
extends AbstractFeature {
    protected abstract Logger getLogger();

    protected void removeInterceptorWhichIsInThePhases(List<Interceptor<? extends Message>> interceptors, String[] phaseNames) {
        block0: for (Interceptor<? extends Message> i : interceptors) {
            if (!(i instanceof PhaseInterceptor)) continue;
            PhaseInterceptor p = (PhaseInterceptor)i;
            for (String phaseName : phaseNames) {
                if (!p.getPhase().equals(phaseName)) continue;
                this.getLogger().info("removing the interceptor " + p);
                interceptors.remove(p);
                continue block0;
            }
        }
    }

    protected void removeInterceptorWhichIsOutThePhases(List<Interceptor<? extends Message>> interceptors, String[] phaseNames) {
        for (Interceptor<? extends Message> i : interceptors) {
            boolean outside = false;
            if (!(i instanceof PhaseInterceptor)) continue;
            PhaseInterceptor p = (PhaseInterceptor)i;
            for (String phaseName : phaseNames) {
                if (!p.getPhase().equals(phaseName)) continue;
                outside = true;
                break;
            }
            if (outside) continue;
            this.getLogger().info("removing the interceptor " + p);
            interceptors.remove(p);
        }
    }

    protected void removeInterceptors(List<Interceptor<? extends Message>> interceptors, Collection<Class> toBeRemovedInterceptors) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!toBeRemovedInterceptors.contains(interceptor.getClass())) continue;
            this.getLogger().info("removing the interceptor " + interceptor);
            interceptors.remove(interceptor);
        }
    }
}

