/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.List;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.RawMessageContentRedirectInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDataFormatFeature.class);
    private static final String[] REMAINING_IN_PHASES = new String[]{"receive", "user-stream", "invoke", "post-invoke"};
    private static final String[] REMAINING_OUT_PHASES = new String[]{"prepare-send", "user-stream", "write", "send", "prepare-send-ending"};

    public void initialize(Client client, Bus bus) {
        this.removeInterceptorWhichIsOutThePhases(client.getInInterceptors(), REMAINING_IN_PHASES);
        this.removeInterceptorWhichIsOutThePhases(client.getEndpoint().getInInterceptors(), REMAINING_IN_PHASES);
        client.getEndpoint().getBinding().getInInterceptors().clear();
        this.removeInterceptorWhichIsOutThePhases(client.getOutInterceptors(), REMAINING_OUT_PHASES);
        this.removeInterceptorWhichIsOutThePhases(client.getEndpoint().getOutInterceptors(), REMAINING_OUT_PHASES);
        client.getEndpoint().getBinding().getOutInterceptors().clear();
        client.getEndpoint().getOutInterceptors().add(new RawMessageContentRedirectInterceptor());
    }

    public void initialize(Server server, Bus bus) {
        Interceptor<? extends Message> wsdlGetInterceptor = this.getInterceptorByName(server.getEndpoint().getInInterceptors(), "org.apache.cxf.frontend.WSDLGetInterceptor");
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getService().getInInterceptors(), REMAINING_IN_PHASES);
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getInInterceptors(), REMAINING_IN_PHASES);
        if (wsdlGetInterceptor != null) {
            server.getEndpoint().getInInterceptors().add(wsdlGetInterceptor);
        }
        server.getEndpoint().getBinding().getInInterceptors().clear();
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getService().getOutInterceptors(), REMAINING_OUT_PHASES);
        this.removeInterceptorWhichIsOutThePhases(server.getEndpoint().getOutInterceptors(), REMAINING_OUT_PHASES);
        server.getEndpoint().getBinding().getOutInterceptors().clear();
        server.getEndpoint().getOutInterceptors().add(new RawMessageContentRedirectInterceptor());
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    private Interceptor<? extends Message> getInterceptorByName(List<Interceptor<? extends Message>> interceptors, String name) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!name.equals(interceptor.getClass().getName())) continue;
            return interceptor;
        }
        return null;
    }
}

