/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CxfPayload<T> {
    private List<Element> body;
    private List<T> headers;

    public CxfPayload(List<T> headers, List<Element> body) {
        this.headers = headers;
        this.body = body;
    }

    public List<Element> getBody() {
        return this.body;
    }

    public List<T> getHeaders() {
        return this.headers;
    }

    public String toString() {
        XmlConverter converter = new XmlConverter();
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append(" headers: " + this.headers);
        if (this.body == null) {
            buf.append("body: " + this.body);
        } else {
            buf.append("body: [ ");
            for (Element element : this.body) {
                String elementString = "";
                try {
                    elementString = converter.toString((Node)element, null);
                }
                catch (TransformerException e) {
                    elementString = element.toString();
                }
                buf.append("[" + elementString + "]");
            }
            buf.append("]");
        }
        return buf.toString();
    }
}

