/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.blueprint.BlueprintSupport;
import org.apache.camel.component.cxf.jaxrs.CxfRsBlueprintEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsSpringEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.CastUtils;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;

public class CxfRsComponent
extends HeaderFilterStrategyComponent {
    public CxfRsComponent() {
    }

    public CxfRsComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CxfRsEndpoint answer = null;
        if (remaining.startsWith("bean:")) {
            AbstractJAXRSFactoryBean bean;
            String beanId = remaining.substring("bean:".length());
            if (beanId.startsWith("//")) {
                beanId = beanId.substring(2);
            }
            answer = (bean = (AbstractJAXRSFactoryBean)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)beanId, AbstractJAXRSFactoryBean.class)) instanceof BlueprintSupport ? new CxfRsBlueprintEndpoint(this.getCamelContext(), bean) : new CxfRsSpringEndpoint(this.getCamelContext(), bean);
            if (bean.getProperties() != null) {
                HashMap copy = new HashMap();
                copy.putAll(bean.getProperties());
                this.setProperties((Object)answer, copy);
            }
        } else {
            answer = new CxfRsEndpoint(remaining, (Component)this);
        }
        Map params = CastUtils.cast(parameters);
        answer.setParameters(params);
        this.setEndpointHeaderFilterStrategy((Endpoint)answer);
        return answer;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)endpoint;
        cxfRsEndpoint.updateEndpointUri(uri);
    }
}

