/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.apache.camel.component.cxf.spring.AbstractCxfBeanDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CxfEndpointBeanDefinitionParser
extends AbstractCxfBeanDefinitionParser {
    protected Class<?> getBeanClass(Element arg0) {
        return CxfSpringEndpoint.class;
    }

    private boolean isSpringPlaceHolder(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}") || value.startsWith("{{") && value.endsWith("}}");
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("endpointName".equals(name) || "serviceName".equals(name)) {
            if (this.isSpringPlaceHolder(val)) {
                this.mapToProperty(bean, name + "String", val);
            } else {
                QName q = this.parseQName(e, val);
                bean.addPropertyValue(name, (Object)q);
            }
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            Map<String, Object> props = this.getPropertyMap(bean, false);
            if (props != null) {
                map.putAll(props);
            }
            bean.addPropertyValue("properties", (Object)map);
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name) || "handlers".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }
}

