/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.MessageContentsList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class CxfConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CxfConverter.class);

    private CxfConverter() {
    }

    @Converter
    public static MessageContentsList toMessageContentsList(Object[] array) {
        if (array != null) {
            return new MessageContentsList(array);
        }
        return new MessageContentsList();
    }

    @Converter
    public static List<Class> toClassesList(String[] classNames) throws ClassNotFoundException {
        ArrayList<Class> answer = new ArrayList<Class>();
        for (String className : classNames) {
            answer.add(ClassLoaderUtils.loadClass((String)className.trim(), CxfConverter.class));
        }
        return answer;
    }

    @Converter
    public static List<Class> toClassList(String classeString) throws ClassNotFoundException {
        String[] classNames = classeString.split(",|;");
        return CxfConverter.toClassesList(classNames);
    }

    @Converter
    public static QName toQName(String qname) {
        return QName.valueOf(qname);
    }

    @Converter
    public static Object[] toArray(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).toArray();
        }
        Object[] answer = object == null ? new Object[]{} : new Object[]{object};
        return answer;
    }

    @Converter
    public static String soapMessageToString(SOAPMessage soapMessage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            soapMessage.writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            LOG.error("Get the exception when converting the SOAPMessage into String, the exception is " + e);
        }
        return baos.toString();
    }

    @Converter
    public static DataFormat toDataFormat(String name) {
        return DataFormat.valueOf(name.toUpperCase());
    }

    @Converter
    public static InputStream toInputStream(Response response, Exchange exchange) {
        Object obj = response.getEntity();
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        TypeConverterRegistry registry = exchange.getContext().getTypeConverterRegistry();
        TypeConverter tc = registry.lookup(InputStream.class, obj.getClass());
        if (tc != null) {
            return (InputStream)tc.convertTo(InputStream.class, exchange, obj);
        }
        return null;
    }

    @FallbackConverter
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (MessageContentsList.class.isAssignableFrom(value.getClass())) {
            MessageContentsList list = (MessageContentsList)value;
            for (Object embedded : list) {
                if (embedded == null) continue;
                if (type.isInstance(embedded)) {
                    return type.cast(embedded);
                }
                TypeConverter tc = registry.lookup(type, embedded.getClass());
                if (tc == null) continue;
                return (T)tc.convertTo(type, exchange, embedded);
            }
            return (T)Void.TYPE;
        }
        if (Response.class.isAssignableFrom(value.getClass())) {
            Response response = (Response)value;
            Object entity = response.getEntity();
            TypeConverter tc = registry.lookup(type, entity.getClass());
            if (tc != null) {
                return (T)tc.convertTo(type, exchange, entity);
            }
            return (T)Void.TYPE;
        }
        return null;
    }
}

