/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.feature;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.component.cxf.feature.AbstractDataFormatFeature;
import org.apache.camel.component.cxf.interceptors.ConfigureDocLitWrapperInterceptor;
import org.apache.camel.component.cxf.interceptors.RemoveClassTypeInterceptor;
import org.apache.camel.component.cxf.interceptors.SetSoapVersionInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayLoadDataFormatFeature
extends AbstractDataFormatFeature {
    private static final Logger LOG = LoggerFactory.getLogger(PayLoadDataFormatFeature.class);
    private static final Collection<Class> REMOVING_FAULT_IN_INTERCEPTORS = new ArrayList<Class>();

    public void initialize(Client client, Bus bus) {
        this.removeFaultInInterceptorFromClient(client);
        client.getEndpoint().getBinding().getInInterceptors().add(new ConfigureDocLitWrapperInterceptor(true));
        client.getEndpoint().getBinding().getInInterceptors().add(new RemoveClassTypeInterceptor());
    }

    public void initialize(Server server, Bus bus) {
        server.getEndpoint().getBinding().getInInterceptors().add(new ConfigureDocLitWrapperInterceptor(true));
        server.getEndpoint().getBinding().getInInterceptors().add(new RemoveClassTypeInterceptor());
        if (server.getEndpoint().getBinding() instanceof SoapBinding) {
            server.getEndpoint().getBinding().getOutInterceptors().add(new SetSoapVersionInterceptor());
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    private void removeFaultInInterceptorFromClient(Client client) {
        this.removeInterceptors(client.getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
        this.removeInterceptors(client.getEndpoint().getService().getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
        this.removeInterceptors(client.getEndpoint().getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
        this.removeInterceptors(client.getEndpoint().getBinding().getInFaultInterceptors(), REMOVING_FAULT_IN_INTERCEPTORS);
    }

    static {
        REMOVING_FAULT_IN_INTERCEPTORS.add(ClientFaultConverter.class);
    }
}

