/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.converter.NodeListWrapper;
import org.apache.camel.spi.TypeConverterRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Converter
public final class CxfPayloadConverter {
    private CxfPayloadConverter() {
    }

    @Converter
    public static <T> CxfPayload<T> documentToCxfPayload(Document doc, Exchange exchange) {
        return CxfPayloadConverter.elementToCxfPayload(doc.getDocumentElement(), exchange);
    }

    @Converter
    public static <T> CxfPayload<T> elementToCxfPayload(Element element, Exchange exchange) {
        ArrayList headers = new ArrayList();
        ArrayList<Element> body = new ArrayList<Element>();
        body.add(element);
        return new CxfPayload(headers, body);
    }

    @Converter
    public static <T> CxfPayload<T> nodeListToCxfPayload(NodeList nodeList, Exchange exchange) {
        ArrayList headers = new ArrayList();
        ArrayList<Element> body = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!Element.class.isAssignableFrom(node.getClass())) continue;
            body.add((Element)node);
        }
        return new CxfPayload(headers, body);
    }

    @Converter
    public static <T> NodeList cxfPayloadToNodeList(CxfPayload<T> payload, Exchange exchange) {
        return new NodeListWrapper(payload.getBody());
    }

    @Converter
    public static <T> Node cxfPayLoadToNode(CxfPayload<T> payload, Exchange exchange) {
        List<Element> payloadBodyElements = payload.getBody();
        if (payloadBodyElements.size() > 0) {
            return payloadBodyElements.get(0);
        }
        return null;
    }

    @FallbackConverter
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (type.isAssignableFrom(CxfPayload.class)) {
            TypeConverter tc = registry.lookup(NodeList.class, value.getClass());
            if (tc != null) {
                NodeList nodeList = (NodeList)tc.convertTo(NodeList.class, exchange, value);
                return (T)CxfPayloadConverter.nodeListToCxfPayload(nodeList, exchange);
            }
            tc = registry.lookup(Document.class, value.getClass());
            if (tc != null) {
                Document document = (Document)tc.convertTo(Document.class, exchange, value);
                return (T)CxfPayloadConverter.documentToCxfPayload(document, exchange);
            }
            CxfPayload<T> p = CxfPayloadConverter.convertVia(InputStream.class, exchange, value, registry);
            if (p != null) {
                return (T)p;
            }
            p = CxfPayloadConverter.convertVia(String.class, exchange, value, registry);
            if (p != null) {
                return (T)p;
            }
            return (T)Void.TYPE;
        }
        if (CxfPayload.class.isAssignableFrom(value.getClass())) {
            TypeConverter tc = registry.lookup(type, NodeList.class);
            if (tc != null) {
                Object result = tc.convertTo(type, (Object)CxfPayloadConverter.cxfPayloadToNodeList((CxfPayload)value, exchange));
                if (result == null) {
                    return (T)Void.TYPE;
                }
                return (T)result;
            }
            tc = registry.lookup(type, Node.class);
            if (tc != null) {
                NodeList nodeList = CxfPayloadConverter.cxfPayloadToNodeList((CxfPayload)value, exchange);
                if (nodeList.getLength() > 0) {
                    return (T)tc.convertTo(type, (Object)nodeList.item(0));
                }
                return (T)Void.TYPE;
            }
        }
        return null;
    }

    private static <T, V> CxfPayload<T> convertVia(Class<V> via, Exchange exchange, Object value, TypeConverterRegistry registry) {
        TypeConverter tc1;
        TypeConverter tc = registry.lookup(via, value.getClass());
        if (tc != null && (tc1 = registry.lookup(Document.class, via)) != null) {
            Object is = tc.convertTo(via, exchange, value);
            Document document = (Document)tc1.convertTo(Document.class, exchange, is);
            return CxfPayloadConverter.documentToCxfPayload(document, exchange);
        }
        return null;
    }
}

