/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dns.DnsComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.Type;

public class DnsDigEndpoint
extends DefaultEndpoint {
    public DnsDigEndpoint(DnsComponent component) {
        super("dns://dig", (Component)component);
    }

    public Consumer createConsumer(Processor arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Producer createProducer() throws Exception {
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                int dclass;
                String server = (String)exchange.getIn().getHeader("dns.server", String.class);
                ObjectHelper.notEmpty((String)server, (String)"Header dns.server");
                SimpleResolver resolver = new SimpleResolver(server);
                int type = Type.value((String)((String)exchange.getIn().getHeader("dns.type", String.class)));
                if (type == -1) {
                    type = 1;
                }
                if ((dclass = DClass.value((String)((String)exchange.getIn().getHeader("dns.class", String.class)))) == -1) {
                    dclass = 1;
                }
                Name name = Name.fromString((String)((String)exchange.getIn().getHeader("dns.name", String.class)), (Name)Name.root);
                Record rec = Record.newRecord((Name)name, (int)type, (int)dclass);
                Message query = Message.newQuery((Record)rec);
                Message response = resolver.send(query);
                exchange.getOut().setBody((Object)response);
            }
        };
    }

    public boolean isSingleton() {
        return false;
    }
}

