/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import java.net.InetAddress;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.xbill.DNS.Address;

public class DnsIpEndpoint
extends DefaultEndpoint {
    public DnsIpEndpoint(Component component) {
        super("dns://ip", component);
    }

    public Producer createProducer() throws Exception {
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                String domain = (String)exchange.getIn().getHeader("dns.domain", String.class);
                ObjectHelper.notEmpty((String)domain, (String)"Header dns.domain");
                InetAddress address = Address.getByName((String)domain);
                exchange.getOut().setBody((Object)address);
            }
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Creating a consumer is not supported");
    }

    public boolean isSingleton() {
        return false;
    }
}

