/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.jaxrs.DockerCmdExecFactoryImpl;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientProfile;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.component.docker.ssl.NoImplSslConfig;
import org.apache.camel.util.ObjectHelper;

public final class DockerClientFactory {
    private DockerClientFactory() {
    }

    public static DockerClient getDockerClient(DockerComponent dockerComponent, DockerConfiguration dockerConfiguration, Message message) throws DockerException {
        NoImplSslConfig sslConfig;
        ObjectHelper.notNull((Object)dockerConfiguration, (String)"dockerConfiguration");
        DockerClientProfile clientProfile = new DockerClientProfile();
        Integer port = DockerHelper.getProperty("CamelDockerPort", dockerConfiguration, message, Integer.class, dockerConfiguration.getPort());
        String host = DockerHelper.getProperty("CamelDockerHost", dockerConfiguration, message, String.class, dockerConfiguration.getHost());
        Integer maxTotalConnections = DockerHelper.getProperty("CamelDockerMaxTotalConnections", dockerConfiguration, message, Integer.class, dockerConfiguration.getMaxTotalConnections());
        Integer maxPerRouteConnections = DockerHelper.getProperty("CamelDockerMaxPerRouteConnections", dockerConfiguration, message, Integer.class, dockerConfiguration.getMaxPerRouteConnections());
        String username = DockerHelper.getProperty("CamelDockerUsername", dockerConfiguration, message, String.class, dockerConfiguration.getUsername());
        String password = DockerHelper.getProperty("CamelDockerPassword", dockerConfiguration, message, String.class, dockerConfiguration.getPassword());
        String email = DockerHelper.getProperty("CamelDockerEmail", dockerConfiguration, message, String.class, dockerConfiguration.getEmail());
        Integer requestTimeout = DockerHelper.getProperty("CamelDockerRequestTimeout", dockerConfiguration, message, Integer.class, dockerConfiguration.getRequestTimeout());
        String serverAddress = DockerHelper.getProperty("CamelDockerServerAddress", dockerConfiguration, message, String.class, dockerConfiguration.getServerAddress());
        String certPath = DockerHelper.getProperty("CamelDockerCertPath", dockerConfiguration, message, String.class, dockerConfiguration.getCertPath());
        Boolean secure = DockerHelper.getProperty("CamelDockerSecure", dockerConfiguration, message, Boolean.class, dockerConfiguration.isSecure());
        clientProfile.setHost(host);
        clientProfile.setPort(port);
        clientProfile.setEmail(email);
        clientProfile.setUsername(username);
        clientProfile.setPassword(password);
        clientProfile.setRequestTimeout(requestTimeout);
        clientProfile.setServerAddress(serverAddress);
        clientProfile.setCertPath(certPath);
        clientProfile.setMaxTotalConnections(maxTotalConnections);
        clientProfile.setMaxPerRouteConnections(maxPerRouteConnections);
        clientProfile.setSecure(secure);
        DockerClient client = dockerComponent.getClient(clientProfile);
        if (client != null) {
            return client;
        }
        if (clientProfile.isSecure() != null && clientProfile.isSecure().booleanValue()) {
            ObjectHelper.notNull((Object)clientProfile.getCertPath(), (String)"certPath must be specified in secure mode");
            sslConfig = new LocalDirectorySSLConfig(clientProfile.getCertPath());
        } else {
            sslConfig = new NoImplSslConfig();
        }
        DockerClientConfig.DockerClientConfigBuilder configBuilder = new DockerClientConfig.DockerClientConfigBuilder().withUsername(clientProfile.getUsername()).withPassword(clientProfile.getPassword()).withEmail(clientProfile.getEmail()).withReadTimeout(clientProfile.getRequestTimeout()).withUri(clientProfile.toUrl()).withMaxPerRouteConnections(clientProfile.getMaxPerRouteConnections()).withMaxTotalConnections(clientProfile.getMaxTotalConnections()).withSSLConfig((SSLConfig)sslConfig).withServerAddress(clientProfile.getServerAddress());
        if (clientProfile.getCertPath() != null) {
            configBuilder.withDockerCertPath(clientProfile.getCertPath());
        }
        DockerClientConfig config = configBuilder.build();
        DockerCmdExecFactoryImpl dockerClientFactory = new DockerCmdExecFactoryImpl();
        client = DockerClientBuilder.getInstance((DockerClientConfig)config).withDockerCmdExecFactory((DockerCmdExecFactory)dockerClientFactory).build();
        dockerComponent.setClient(clientProfile, client);
        return client;
    }
}

