/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.dozer.DozerTypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.TypeConverterRegistry;
import org.dozer.DozerBeanMapper;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.MappingFileData;
import org.dozer.config.BeanContainer;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.MappingFileReader;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.DozerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerTypeConverterLoader
implements CamelContextAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private CamelContext camelContext;
    private DozerBeanMapper mapper;

    public DozerTypeConverterLoader() {
    }

    public DozerTypeConverterLoader(CamelContext camelContext) {
        this.init(camelContext, null);
    }

    public DozerTypeConverterLoader(CamelContext camelContext, DozerBeanMapper mapper) {
        this.init(camelContext, mapper);
    }

    public void init(CamelContext camelContext, DozerBeanMapper mapper) {
        this.camelContext = camelContext;
        this.mapper = mapper;
        CamelToDozerClassResolverAdapter adapter = new CamelToDozerClassResolverAdapter(camelContext);
        BeanContainer.getInstance().setClassLoader((DozerClassLoader)adapter);
        HashMap<String, DozerBeanMapper> mappers = new HashMap<String, DozerBeanMapper>(camelContext.getRegistry().lookupByType(DozerBeanMapper.class));
        if (mapper != null) {
            mappers.put("parameter", mapper);
        }
        if (mappers.size() > 1) {
            this.log.warn("Loaded " + mappers.size() + " Dozer mappers from Camel registry." + " Dozer is most efficient when there is a single mapper instance. Consider amalgamating instances.");
        } else if (mappers.size() == 0) {
            this.log.warn("No Dozer mappers found in Camel registry. You should add Dozer mappers as beans to the registry of the type: " + DozerBeanMapper.class.getName());
        }
        TypeConverterRegistry registry = camelContext.getTypeConverterRegistry();
        for (DozerBeanMapper dozer : mappers.values()) {
            List<ClassMap> all = this.loadMappings(camelContext, dozer);
            this.registerClassMaps(registry, dozer, all);
        }
    }

    private void registerClassMaps(TypeConverterRegistry registry, DozerBeanMapper dozer, List<ClassMap> all) {
        DozerTypeConverter converter = new DozerTypeConverter(dozer);
        for (ClassMap map : all) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Added {} -> {} as type converter to: {}", new Object[]{map.getSrcClassName(), map.getDestClassName(), registry});
            }
            registry.addTypeConverter(map.getSrcClassToMap(), map.getDestClassToMap(), (TypeConverter)converter);
            registry.addTypeConverter(map.getDestClassToMap(), map.getSrcClassToMap(), (TypeConverter)converter);
        }
    }

    private List<ClassMap> loadMappings(CamelContext camelContext, DozerBeanMapper mapper) {
        ArrayList<ClassMap> answer = new ArrayList<ClassMap>();
        MappingFileReader reader = new MappingFileReader(XMLParserFactory.getInstance());
        List mappingFiles = mapper.getMappingFiles();
        if (mappingFiles == null) {
            return Collections.emptyList();
        }
        for (String name : mappingFiles) {
            URL url = camelContext.getClassResolver().loadResourceAsURL(name);
            MappingFileData data = reader.read(url);
            answer.addAll(data.getClassMaps());
        }
        return answer;
    }

    public void addMapping(BeanMappingBuilder beanMappingBuilder) {
        if (this.mapper == null) {
            this.log.warn("No mapper instance provided to " + this.getClass().getSimpleName() + ". Mapping has not been registered!");
            return;
        }
        this.mapper.addMapping(beanMappingBuilder);
        MappingFileData mappingFileData = beanMappingBuilder.build();
        TypeConverterRegistry registry = this.camelContext.getTypeConverterRegistry();
        ArrayList<ClassMap> classMaps = new ArrayList<ClassMap>();
        classMaps.addAll(mappingFileData.getClassMaps());
        this.registerClassMaps(registry, this.mapper, classMaps);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.init(camelContext, null);
    }

    private static final class CamelToDozerClassResolverAdapter
    implements DozerClassLoader {
        private final ClassResolver classResolver;

        private CamelToDozerClassResolverAdapter(CamelContext camelContext) {
            this.classResolver = camelContext.getClassResolver();
        }

        public Class<?> loadClass(String s) {
            return this.classResolver.resolveClass(s);
        }

        public URL loadResource(String s) {
            URL url = this.classResolver.loadResourceAsURL(s);
            if (url == null) {
                url = DozerClassLoader.class.getClassLoader().getResource(s);
            }
            return url;
        }
    }
}

