/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.dozer.BaseConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;

public class ExpressionMapper
extends BaseConverter {
    private ThreadLocal<Exchange> currentExchange = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
        try {
            if (this.currentExchange.get() == null) {
                throw new IllegalStateException("Current exchange has not been set for ExpressionMapper");
            }
            Exchange exchange = this.currentExchange.get();
            Language expLang = exchange.getContext().resolveLanguage(this.getLanguagePart());
            String scheme = this.getSchemePart();
            Expression exp = null;
            if (scheme != null && (scheme.equalsIgnoreCase("classpath") || scheme.equalsIgnoreCase("file") || scheme.equalsIgnoreCase("http"))) {
                String path = this.getPathPart();
                try {
                    exp = expLang.createExpression(this.resolveScript(scheme + ":" + path));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Expression script specified but not found", e);
                }
            } else {
                exp = expLang.createExpression(this.getExpressionPart());
            }
            Object object = exp.evaluate(exchange, destinationClass);
            return object;
        }
        finally {
            this.done();
        }
    }

    protected String resolveScript(String script) throws IOException {
        String answer;
        if (ResourceHelper.hasScheme((String)script)) {
            InputStream is = this.loadResource(script);
            answer = (String)this.currentExchange.get().getContext().getTypeConverter().convertTo(String.class, (Object)is);
            IOHelper.close((Closeable)is);
        } else {
            answer = script;
        }
        return answer;
    }

    protected InputStream loadResource(String uri) throws IOException {
        return ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.currentExchange.get().getContext().getClassResolver(), (String)uri);
    }

    public String getExpression() {
        return this.getParameter();
    }

    public String getExpressionPart() {
        return this.getParameter().substring(this.getParameter().indexOf(":") + 1);
    }

    public String getLanguagePart() {
        return this.getParameter().substring(0, this.getParameter().indexOf(":"));
    }

    public void setCurrentExchange(Exchange exchange) {
        this.currentExchange.set(exchange);
    }

    public String getSchemePart() {
        return this.getParameterPart(":", 1);
    }

    public String getPathPart() {
        return this.getParameterPart(":", 2);
    }

    private String getParameterPart(String separator, int idx) {
        String part = null;
        String[] parts = this.getParameter().split(separator);
        if (parts.length > idx) {
            part = parts[idx];
        }
        return part;
    }
}

