/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.PackageHelper;
import org.apache.camel.util.JsonSchemaHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocumentationEnricher {
    public void enrichTopLevelElementsDocumentation(Document document, NodeList elements, Map<String, File> jsonFiles) throws IOException {
        for (int i = 0; i < elements.getLength(); ++i) {
            Element item = (Element)elements.item(i);
            String name = item.getAttribute("name");
            if (!jsonFiles.containsKey(name)) continue;
            this.addElementDocumentation(document, item, jsonFiles.get(name));
        }
    }

    public void enrichTypeAttributesDocumentation(Document document, NodeList attributeElements, File jsonFile) throws IOException {
        for (int j = 0; j < attributeElements.getLength(); ++j) {
            Element item = (Element)attributeElements.item(j);
            this.addAttributeDocumentation(item, jsonFile, document);
        }
    }

    private void addElementDocumentation(Document document, Element item, File jsonFile) throws IOException {
        List rows = JsonSchemaHelper.parseJsonSchema((String)"model", (String)PackageHelper.fileToString(jsonFile), (boolean)false);
        for (Map row : rows) {
            if (!row.containsKey("description")) continue;
            String descriptionText = (String)row.get("description");
            this.addDocumentation(document, item, descriptionText);
            break;
        }
    }

    private void addAttributeDocumentation(Element item, File jsonFile, Document document) throws IOException {
        List rows = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)PackageHelper.fileToString(jsonFile), (boolean)true);
        for (Map row : rows) {
            String descriptionText;
            if (!item.getAttribute("name").equals(row.get("name")) || (descriptionText = (String)row.get("description")) == null) continue;
            this.addDocumentation(document, item, descriptionText);
            break;
        }
    }

    private void addDocumentation(Document document, Element item, String textContent) {
        Element annotation = document.createElement("xs:annotation");
        Element documentation = document.createElement("xs:documentation");
        documentation.setAttribute("xml:lang", "en");
        documentation.setTextContent(textContent);
        annotation.appendChild(documentation);
        if (item.getFirstChild() != null) {
            item.insertBefore(annotation, item.getFirstChild());
        } else {
            item.appendChild(annotation);
        }
    }
}

